<?php $__env->startSection('styles'); ?>
    <?php echo $__env->yieldPushContent('datatableStyles'); ?>
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <style>
        .bold {
            font-weight: bold;
        }

        .underline-line {
            text-decoration: underline;
        }

        .schedule-row {
            border: 1px solid #e0e0e0;
            padding: 15px 15px 10px 15px;
            border-radius: 6px;
            margin-bottom: 12px;
            background-color: #f9f9f9;
            position: relative;
        }

        #add-schedule,
        .btn-remove-schedule {
            width: 38px;
            height: 38px;
            font-size: 20px;
            line-height: 1;
            padding: 0;
            display: flex;
            align-items: center;
            justify-content: center;
            border-radius: 50%;
            border: 1px solid #0A4199;
            background: white;
            color: #0A4199;
            cursor: pointer;
            transition: background-color 0.3s ease, color 0.3s ease;
            user-select: none;
            font-weight: bold;
        }

        #add-schedule:hover,
        .btn-remove-schedule:hover {
            background-color: #0A4199;
            color: white;
        }

        .schedule-controls {
            display: flex;
            gap: 8px;
            justify-content: flex-end;
            height: 100%;
        }

        .label-with-btn {
            display: flex;
            align-items: center;
            gap: 10px;
        }


        .row.g-3 > [class*='col-'] {
            margin-bottom: 12px;
        }

        @media (max-width: 575.98px) {
            .schedule-row .form-group {
                margin-bottom: 10px;
            }
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('title'); ?>
    <?php echo e(__('Add Group')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="app-content content">
        <div class="content-overlay"></div>
        <div class="header-navbar-shadow"></div>
        <div class="content-wrapper">
            <div class="content-header row"></div>
            <div class="content-body">

                <?php if (isset($component)) { $__componentOriginalddcd638d544798a22b5064bdbb7bdb0c = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalddcd638d544798a22b5064bdbb7bdb0c = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.dashboard.layouts.breadcrumb','data' => ['now' => ''.e(__('Add Group')).'']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('dashboard.layouts.breadcrumb'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['now' => ''.e(__('Add Group')).'']); ?>
                    <li class="breadcrumb-item"><a href="<?php echo e(route('teacher.groups.index')); ?>">
                            <?php echo e(__('Groups')); ?>

                        </a></li>
                 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalddcd638d544798a22b5064bdbb7bdb0c)): ?>
<?php $attributes = $__attributesOriginalddcd638d544798a22b5064bdbb7bdb0c; ?>
<?php unset($__attributesOriginalddcd638d544798a22b5064bdbb7bdb0c); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalddcd638d544798a22b5064bdbb7bdb0c)): ?>
<?php $component = $__componentOriginalddcd638d544798a22b5064bdbb7bdb0c; ?>
<?php unset($__componentOriginalddcd638d544798a22b5064bdbb7bdb0c); ?>
<?php endif; ?>


                <section id="basic-input">
                    <div class="row justify-content-center">
                        <div class="col-xl-10 col-lg-11 col-md-12 col-12">
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title"><?php echo e(__('Add Group')); ?></h4>
                                </div>
                                <div class="card-content">
                                    <div class="card-body">
                                        <form id="groupForm" action="<?php echo e(route('teacher.groups.store')); ?>" method="POST" novalidate>
                                            <?php echo csrf_field(); ?>

                                            <div class="row g-3">
                                                <div class="col-md-3 col-12">
                                                    <label for="title" class="form-label font-weight-bold underline-line"><?php echo e(__('Title')); ?></label>
                                                    <input type="text" name="title" id="title" class="form-control"
                                                           value="<?php echo e(old('title')); ?>"  placeholder="<?php echo e(__('Title')); ?>">
                                                    <?php $__errorArgs = ['title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="text-danger mt-1 small">
                                                        <i class="fas fa-exclamation-circle me-1"></i> <?php echo e($message); ?>

                                                    </div>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>

                                                <div class="col-md-6 col-12">
                                                    <label for="grade_ids" class="form-label font-weight-bold underline-line"><?php echo e(__('Grades')); ?></label>
                                                    <select id="grade_ids" name="grade_ids[]" class="form-control select2 select-group mb-2" multiple>
                                                        <?php $__currentLoopData = $grades; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $grade): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($grade->id); ?>" <?php echo e(collect(old('grade_ids'))->contains($grade->id) ? 'selected' : ''); ?>>
                                                                <?php echo e($grade->name); ?>

                                                            </option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>

                                                    <?php $__errorArgs = ['grade_ids'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="text-danger mt-1 small">
                                                        <i class="fas fa-exclamation-circle me-1"></i> <?php echo e($message); ?>

                                                    </div>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>

                                                <div class="col-md-4 col-12 seletc-test">
                                                    <label for="standardized_test_id" class="form-label font-weight-bold underline-line"><?php echo e(__('Test Type')); ?></label>
                                                    <select name="standardized_test_id" id="standardized_test_id" class="form-control">
                                                        <option value=""><?php echo e(__('Select Test Type')); ?></option>
                                                        <?php $__currentLoopData = $tests; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $test): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($test->id); ?>" <?php echo e(old('standardized_test_id') == $test->id ? 'selected' : ''); ?>>
                                                                <?php echo e($test->name); ?>

                                                            </option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>
                                                    <?php $__errorArgs = ['standardized_test_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="text-danger mt-1 small">
                                                        <i class="fas fa-exclamation-circle me-1"></i> <?php echo e($message); ?>

                                                    </div>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>

                                                <div class="col-md-2 col-12 select-group">
                                                    <label for="status" class="form-label font-weight-bold underline-line"><?php echo e(__('Status')); ?></label>
                                                    <select name="status" id="status" class="form-control">
                                                        <option value="1" <?php echo e(old('status', '1') == '1' ? 'selected' : ''); ?>><?php echo e(__('Active')); ?></option>
                                                        <option value="0" <?php echo e(old('status') == '0' ? 'selected' : ''); ?>><?php echo e(__('Inactive')); ?></option>
                                                    </select>
                                                    <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="text-danger mt-1 small">
                                                        <i class="fas fa-exclamation-circle me-1"></i> <?php echo e($message); ?>

                                                    </div>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>

                                                <div class="col-md-3 col-12 select-group">
                                                    <label for="max_students" class="form-label font-weight-bold underline-line"><?php echo e(__('Max Students')); ?></label>
                                                    <input type="number" name="max_students" id="max_students" class="form-control"
                                                           value="<?php echo e(old('max_students', 0)); ?>" min="0" placeholder="<?php echo e(__('Enter max students')); ?>">
                                                    <?php $__errorArgs = ['max_students'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="text-danger mt-1 small">
                                                        <i class="fas fa-exclamation-circle me-1"></i> <?php echo e($message); ?>

                                                    </div>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>

                                                <div class="col-12 position-relative">
                                                    <div class="label-with-btn mb-1 d-flex align-items-center justify-content-between">
                                                        <label class="form-label font-weight-bold underline-line mb-0"><?php echo e(__('Schedules')); ?></label>
                                                        <div class="col-md-3 d-flex align-items-end schedule-controls px-1">
                                                            <button type="button" id="add-schedule" title="<?php echo e(__('Add Schedule')); ?>">+</button>
                                                        </div>
                                                    </div>

                                                    <div id="schedule-wrapper">
                                                        <div class="schedule-row">
                                                            <div class="row g-3">
                                                                <div class="col-md-3">
                                                                    <label class="form-label"><?php echo e(__('Day')); ?></label>
                                                                    <select name="schedules[0][day]" class="form-control" required>
                                                                        <option value=""><?php echo e(__('Select Day')); ?></option>
                                                                        <?php $__currentLoopData = \App\Enum\DaysEnum::getValues(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $day): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                            <option value="<?php echo e($day); ?>"><?php echo e(__($day)); ?></option>
                                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                    </select>
                                                                </div>

                                                                <div class="col-md-3">
                                                                    <label class="form-label"><?php echo e(__('From')); ?></label>
                                                                    <input type="time" name="schedules[0][start_time]" class="form-control" required>
                                                                </div>



                                                                <div class="col-md-3">
                                                                    <label class="form-label"><?php echo e(__('To')); ?></label>
                                                                    <input type="time" name="schedules[0][end_time]" class="form-control" required>
                                                                </div>


                                                                <div class="col-md-3 d-flex align-items-end schedule-controls">
                                                                    <button type="button" class="btn btn-outline-danger rounded-circle btn-remove-schedule">&minus;</button>
                                                                </div>
                                                                <?php $__errorArgs = ['schedules.0.start_time'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                <div class="text-danger mt-1 small">
                                                                    <i class="fas fa-exclamation-circle me-1"></i> <?php echo e($message); ?>

                                                                </div>
                                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="col-12 mt-4 d-flex justify-content-end">
                                                    <button id="submitGroupForm" type="submit" class="btn btn-primary px-5"><?php echo e(__('Save')); ?></button>
                                                </div>

                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>

            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <?php echo $__env->yieldPushContent('datatableScripts'); ?>

    <script>
        let scheduleIndex = 1;

        const wrapper = document.getElementById('schedule-wrapper');
        const addBtn = document.getElementById('add-schedule');

        function createScheduleRow(index) {
            const row = document.createElement('div');
            row.classList.add('schedule-row');
            row.innerHTML = `
                <div class="row g-3">
                    <div class="col-md-3">
                        <label class="form-label"><?php echo e(__('Day')); ?></label>
                        <select name="schedules[${index}][day]" class="form-control" required>
                            <option value=""><?php echo e(__('Select Day')); ?></option>
                            <?php $__currentLoopData = \App\Enum\DaysEnum::getValues(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $day): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?php echo e($day); ?>"><?php echo e(__($day)); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>
        <div class="col-md-3">
            <label class="form-label"><?php echo e(__('From')); ?></label>
                        <input type="time" name="schedules[${index}][start_time]" class="form-control" required>
                    </div>
                    <div class="col-md-3">
                        <label class="form-label"><?php echo e(__('To')); ?></label>
                        <input type="time" name="schedules[${index}][end_time]" class="form-control" required>
                    </div>
                    <div class="col-md-3 d-flex align-items-end schedule-controls">
                        <button type="button" class="btn btn-outline-danger rounded-circle btn-remove-schedule">&minus;</button>
                    </div>
                </div>
            `;
            return row;
        }

        addBtn.addEventListener('click', () => {
            const newRow = createScheduleRow(scheduleIndex);
            wrapper.appendChild(newRow);
            scheduleIndex++;
        });
        document.getElementById('groupForm').addEventListener('submit', function (e) {
            let btn = document.getElementById('submitGroupForm');
            btn.disabled = true;
            btn.innerHTML = '<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>';
        });

        wrapper.addEventListener('click', function (e) {
            if (e.target && e.target.classList.contains('btn-remove-schedule')) {
                const schedules = wrapper.querySelectorAll('.schedule-row');
                if (schedules.length > 1) {
                    e.target.closest('.schedule-row').remove();
                } else {
                    alert("<?php echo e(__('At least one schedule is required.')); ?>");
                }
            }
        });
    </script>

    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script>
        $(document).ready(function() {
            $('#grade_ids').select2({
                placeholder: "<?php echo e(__('Select Grades')); ?>",
                allowClear: true,
                width: '100%'
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('components.dashboard.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/am2/public_html/resources/views/dashboard/groups/create.blade.php ENDPATH**/ ?>