<?php $__env->startSection('styles'); ?>
    <?php echo $__env->yieldPushContent('datatableStyles'); ?>
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <style>
        .select2-container--default .select2-results__option {
            white-space: normal;
        }
        .schedule-badge {
            display: inline-block;
            background-color: #0d6efd;
            color: white;
            padding: 2px 6px;
            margin-right: 4px;
            border-radius: 4px;
            font-size: 0.85rem;
        }
        .btn-close-custom {
            width: 40px;
            height: 40px;
            position: absolute;
            top: 10px;
            right: 10px;
            font-size: 24px;
            line-height: 1;
            display: flex;
            align-items: center;
            justify-content: center;
            border-radius: 50%;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('title'); ?>
    <?php echo e(__('Students List')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="app-content content">
        <div class="content-overlay"></div>
        <div class="header-navbar-shadow"></div>
        <div class="content-wrapper">
            <div class="content-header row"></div>
            <div class="content-body">
                <section class="users-list-wrapper">
                    <?php if (isset($component)) { $__componentOriginalddcd638d544798a22b5064bdbb7bdb0c = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalddcd638d544798a22b5064bdbb7bdb0c = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.dashboard.layouts.breadcrumb','data' => ['now' => ''.e(__('Students List')).'']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('dashboard.layouts.breadcrumb'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['now' => ''.e(__('Students List')).'']); ?> <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalddcd638d544798a22b5064bdbb7bdb0c)): ?>
<?php $attributes = $__attributesOriginalddcd638d544798a22b5064bdbb7bdb0c; ?>
<?php unset($__attributesOriginalddcd638d544798a22b5064bdbb7bdb0c); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalddcd638d544798a22b5064bdbb7bdb0c)): ?>
<?php $component = $__componentOriginalddcd638d544798a22b5064bdbb7bdb0c; ?>
<?php unset($__componentOriginalddcd638d544798a22b5064bdbb7bdb0c); ?>
<?php endif; ?>

                    <section id="column-selectors">
                        <div class="row">
                            <div class="col-12">
                                <div class="card">
                                    <div class="card-header">
                                        <h4 class="card-title"><?php echo e(__('Students List')); ?></h4>
                                    </div>
                                    <div class="card-content">
                                        <div class="card-body card-dashboard">
                                            <?php if (isset($component)) { $__componentOriginal858a02b2c90508d942c260e414df2962 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal858a02b2c90508d942c260e414df2962 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.pages.datatable','data' => ['title' => __('Add Group'),'route' => 'teacher.groups.show_students','params' => ['group' => $group->id],'datatable' => $dataTable,'create' => false]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('pages.datatable'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(__('Add Group')),'route' => 'teacher.groups.show_students','params' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(['group' => $group->id]),'datatable' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($dataTable),'create' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(false)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal858a02b2c90508d942c260e414df2962)): ?>
<?php $attributes = $__attributesOriginal858a02b2c90508d942c260e414df2962; ?>
<?php unset($__attributesOriginal858a02b2c90508d942c260e414df2962); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal858a02b2c90508d942c260e414df2962)): ?>
<?php $component = $__componentOriginal858a02b2c90508d942c260e414df2962; ?>
<?php unset($__componentOriginal858a02b2c90508d942c260e414df2962); ?>
<?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </section>
                </section>
            </div>
        </div>
    </div>

    <div class="modal fade" id="transferStudentModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo e(__('Transfer Student')); ?></h5>

                </div>
                <div class="modal-body">
                    <form id="transferStudentForm" method="POST"
                          action="<?php echo e(route('teacher.groups.transfer_student', ['group' => $group->id])); ?>">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="student_id" id="student_id">
                        <input type="hidden" name="old_group_id" id="old_group_id">

                        <div class="mb-3">
                            <label for="standardized_test_id" class="form-label"><?php echo e(__('Select Test')); ?></label>
                            <select name="standardized_test_id" id="standardized_test_id" class="form-select" required>
                                <option value=""><?php echo e(__('Select Test')); ?></option>
                                <?php $__currentLoopData = $allTests; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $test): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($test->id); ?>" data-groups='<?php echo json_encode($test->groups, 15, 512) ?>'><?php echo e($test->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>

                        <div class="mb-3">
                            <label for="group_id" class="form-label"><?php echo e(__('Select Group & Schedule')); ?></label>
                            <select name="new_group_id" id="group_id" class="form-select" required>
                                <option value=""><?php echo e(__('Select Group & Schedule')); ?></option>
                            </select>
                        </div>

                        <div class="text-end">
                            <button type="submit" class="btn btn-primary"><?php echo e(__('Transfer')); ?></button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <?php echo $__env->yieldPushContent('datatableScripts'); ?>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

    <script>
        $(document).ready(function() {
            $('#standardized_test_id, #group_id').select2({
                width: '100%',
                dropdownParent: $('#transferStudentModal'),
                placeholder: function(){
                    $(this).data('placeholder');
                }
            });
        });

        $(document).on('click', '.transfer-btn', function() {
            let studentId = $(this).data('studentId');
            let oldGroupId = $(this).data('oldGroupId');

            console.log('Student ID:', studentId, 'Old Group ID:', oldGroupId);

            $('#student_id').val(studentId);
            $('#old_group_id').val(oldGroupId);

            $('#standardized_test_id').val('').trigger('change');
            $('#group_id').html('<option value=""><?php echo e(__("Select Group & Schedule")); ?></option>').trigger('change');

            $('#transferStudentModal').modal('show');
        });

        $('#standardized_test_id').on('change', function() {
            let groups = $(this).find(':selected').data('groups') || [];
            let groupScheduleSelect = $('#group_id');
            groupScheduleSelect.html('<option value=""><?php echo e(__("Select Group & Schedule")); ?></option>');

            groups.forEach(function(group){
                let schedulesText = '';
                if(group.schedules && group.schedules.length > 0){
                    schedulesText = group.schedules.map(s => {
                        if(!s.day || !s.start_time || !s.end_time) return '';
                        return `<span class="schedule-badge">${s.day} ${s.start_time}-${s.end_time}</span>`;
                    }).filter(text => text !== '').join(' | ');
                }

                let optionText = group.name ?? 'Group';
                if(schedulesText) optionText += ' ' + schedulesText;

                groupScheduleSelect.append(
                    `<option value="${group.id}">${optionText}</option>`
                );
            });

            groupScheduleSelect.trigger('change');
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('components.dashboard.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/am2/public_html/resources/views/dashboard/groups/students_group.blade.php ENDPATH**/ ?>