<?php $__env->startSection('title', __('dashboard.settings')); ?>

<?php $__env->startSection('styles'); ?>
    <link href="https://cdn.quilljs.com/1.3.6/quill.snow.css" rel="stylesheet">
    <style>
        .nav-link.active {
            background-color: #0A4199 !important;
            color: #fff !important;
        }
        .quill-editor {
            min-height: 300px;
            background: #fff;
            border: 1px solid #ddd;
            padding: 15px;
            overflow: auto;
        }
        .list-group-item.active  {
            z-index: 2;
            color: #FFFFFF;
            background-color: #0A4199;
            border-color: #0A4199;
        }
        .list-group .list-group-item.active:hover {
            background-color: #0A4199;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="app-content content">
        <div class="content-wrapper">
            <?php if (isset($component)) { $__componentOriginalddcd638d544798a22b5064bdbb7bdb0c = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalddcd638d544798a22b5064bdbb7bdb0c = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.dashboard.layouts.breadcrumb','data' => ['now' => ''.e(__('dashboard.app_settings')).'']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('dashboard.layouts.breadcrumb'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['now' => ''.e(__('dashboard.app_settings')).'']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalddcd638d544798a22b5064bdbb7bdb0c)): ?>
<?php $attributes = $__attributesOriginalddcd638d544798a22b5064bdbb7bdb0c; ?>
<?php unset($__attributesOriginalddcd638d544798a22b5064bdbb7bdb0c); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalddcd638d544798a22b5064bdbb7bdb0c)): ?>
<?php $component = $__componentOriginalddcd638d544798a22b5064bdbb7bdb0c; ?>
<?php unset($__componentOriginalddcd638d544798a22b5064bdbb7bdb0c); ?>
<?php endif; ?>

            <div class="row">
                <!-- Sidebar Navigation -->
                <div class="col-md-3">
                    <div class="list-group">
                        <a href="<?php echo e(route('admin.settings.index', ['page' => 'about-us'])); ?>"
                           class="list-group-item list-group-item-action <?php echo e($page === 'about-us' ? 'active' : ''); ?>">
                            <?php echo e(__('About Us')); ?>

                        </a>
                        <a href="<?php echo e(route('admin.settings.index', ['page' => 'privacy'])); ?>"
                           class="list-group-item list-group-item-action <?php echo e($page === 'privacy' ? 'active' : ''); ?>">
                            <?php echo e(__('Privacy Policy')); ?>

                        </a>
                        <a href="<?php echo e(route('admin.settings.index', ['page' => 'social-media'])); ?>"
                           class="list-group-item list-group-item-action <?php echo e($page === 'social-media' ? 'active' : ''); ?>">
                            <?php echo e(__('Social Media Links')); ?>

                        </a>
                        <a href="<?php echo e(route('admin.settings.index', ['page' => 'contact-us'])); ?>"
                           class="list-group-item list-group-item-action <?php echo e($page === 'contact-us' ? 'active' : ''); ?>">
                            <?php echo e(__('Contact Us')); ?>

                        </a>
                        <a href="<?php echo e(route('admin.settings.index', ['page' => 'allowed_absence_days'])); ?>"
                           class="list-group-item list-group-item-action <?php echo e($page === 'allowed_absence_days' ? 'active' : ''); ?>">
                            <?php echo e(__('Allowed Absence Days')); ?>

                        </a>
                        <a href="<?php echo e(route('admin.settings.index', ['page' => 'screenshot_protection'])); ?>"
                           class="list-group-item list-group-item-action <?php echo e($page === 'screenshot_protection' ? 'active' : ''); ?>">
                            <?php echo e(__('Screenshot Protection')); ?>


                            <a href="<?php echo e(route('admin.settings.index', ['page' => 'fees'])); ?>"
                               class="list-group-item list-group-item-action <?php echo e($page === 'fees' ? 'active' : ''); ?>">
                                <?php echo e(__('Fees Protection')); ?>

                            </a>
                        </a>

                    </div>
                </div>

                <!-- Main Content -->
                <div class="col-md-9">

                    
                    <?php $__currentLoopData = $settings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $setting): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $content = json_decode($setting->value, true);
                        ?>

                        <?php if($page === $setting->key && !in_array($page, ['facebook_link', 'instagram_link', 'contact-us','screenshot_protection','allowed_absence_days','fees'])): ?>
                            <div class="card mb-4">
                                <div class="card-header d-flex justify-content-between align-items-center">
                                    <h5 class="mb-0"><?php echo e(__("{$setting->key} (Arabic)")); ?></h5>
                                </div>
                                <div class="card-body">
                                    <form method="POST"
                                          action="<?php echo e(route('admin.settings.update', $setting->id)); ?>"
                                          id="formAr_<?php echo e($setting->key); ?>"
                                          class="d-none">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('PATCH'); ?>
                                        <textarea name="content[ar]" id="inputAr_<?php echo e($setting->key); ?>" class="d-none"></textarea>
                                    </form>

                                    <div id="editorAr_<?php echo e($setting->key); ?>" class="quill-editor" dir="rtl" lang="ar">
                                        <?php echo $content['ar'] ?? ''; ?>

                                    </div>

                                    <button class="btn btn-primary mt-3"
                                            onclick="submitQuillForm('Ar', '<?php echo e($setting->key); ?>')">
                                        <?php echo e(__('Save')); ?>

                                    </button>
                                </div>
                            </div>

                            <div class="card">
                                <div class="card-header">
                                    <h5 class="mb-0"><?php echo e(__("{$setting->key} (English)")); ?></h5>
                                </div>
                                <div class="card-body">
                                    <form method="POST"
                                          action="<?php echo e(route('admin.settings.update', $setting->id)); ?>"
                                          id="formEn_<?php echo e($setting->key); ?>"
                                          class="d-none">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('PATCH'); ?>
                                        <textarea name="content[en]" id="inputEn_<?php echo e($setting->key); ?>" class="d-none"></textarea>
                                    </form>

                                    <div id="editorEn_<?php echo e($setting->key); ?>" class="quill-editor" dir="ltr" lang="en">
                                        <?php echo $content['en'] ?? ''; ?>

                                    </div>

                                    <button class="btn btn-primary mt-3"
                                            onclick="submitQuillForm('En', '<?php echo e($setting->key); ?>')">
                                        <?php echo e(__('Save')); ?>

                                    </button>
                                </div>
                            </div>
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    
                    <?php if($page === 'contact-us'): ?>
                        <?php
                            $contactSetting = $settings->firstWhere('key', 'contact-us');
                            // Always decode as array, fallback to empty array if invalid
                            $contactValue = $contactSetting ? json_decode($contactSetting->value, true) ?? [] : [];
                            // Ensure it's always an array for the foreach
                            $contactValue = is_array($contactValue) ? $contactValue : [];
                        ?>
                        <div class="card mb-4">
                            <div class="card-header">
                                <h5 class="mb-0"><?php echo e(__('Contact Us')); ?></h5>
                            </div>
                            <div class="card-body">
                                <form method="POST" action="<?php echo e(route('admin.settings.update', $contactSetting->id ?? 0)); ?>">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('PATCH'); ?>

                                    <div class="form-group">
                                        <label for="contact_value"><?php echo e(__('Phone')); ?></label>
                                        <select id="contact_value" name="value[]" class="form-control" multiple>
                                            <?php $__currentLoopData = $contactValue; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($option); ?>" selected><?php echo e($option); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>

                                    <button type="submit" class="btn btn-primary mt-3"><?php echo e(__('Save')); ?></button>
                                </form>
                            </div>
                        </div>
                    <?php endif; ?>

                    
                    <?php if($page === 'social-media'): ?>
                        <?php
                            $facebookSetting = $settings->firstWhere('key', 'facebook_link');
                            $instagramSetting = $settings->firstWhere('key', 'instagram_link');

                            $facebookLink = $facebookSetting ? json_decode($facebookSetting->value, true) : '';
                            $instagramLink = $instagramSetting ? json_decode($instagramSetting->value, true) : '';
                            if (is_array($facebookLink)) $facebookLink = $facebookSetting->value;
                            if (is_array($instagramLink)) $instagramLink = $instagramSetting->value;
                        ?>

                        <div class="card">
                            <div class="card-header">
                                <h5 class="mb-0"><?php echo e(__('Social Media Links')); ?></h5>
                            </div>
                            <div class="card-body">

                                
                                <form method="POST" action="<?php echo e(route('admin.settings.update', $facebookSetting->id ?? 0)); ?>">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('PATCH'); ?>
                                    <div class="form-group mb-3">
                                        <label for="facebook"><?php echo e(__('Facebook Link')); ?></label>
                                        <input type="text" name="value" id="facebook" class="form-control"
                                               value="<?php echo e($facebookLink); ?>">
                                    </div>
                                    <button type="submit" class="btn btn-primary"><?php echo e(__('Save Facebook')); ?></button>
                                </form>

                                <hr>

                                
                                <form method="POST" action="<?php echo e(route('admin.settings.update', $instagramSetting->id ?? 0)); ?>">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('PATCH'); ?>
                                    <div class="form-group mb-3">
                                        <label for="instagram"><?php echo e(__('Instagram Link')); ?></label>
                                        <input type="text" name="value" id="instagram" class="form-control"
                                               value="<?php echo e($instagramLink); ?>">
                                    </div>
                                    <button type="submit" class="btn btn-primary"><?php echo e(__('Save Instagram')); ?></button>
                                </form>
                            </div>
                        </div>
                    <?php endif; ?>
                    <?php if($page === 'allowed_absence_days'): ?>
                        <div class="card">
                            <div class="card-header">
                                <h5 class="mb-0"><?php echo e(__('Allowed Absence Days')); ?></h5>
                            </div>
                            <div class="card-body">
                                <?php
                                    $setting  =  $settings->firstWhere('key', 'allowed_absence_days');
                                    $day = $setting ? json_decode($setting->value, true) : '';

                                ?>

                                <form method="POST" action="<?php echo e(route('admin.settings.update', $setting->id)); ?>">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('PATCH'); ?>

                                    <div class="form-group mb-3">
                                        <label for="allowed_absence_days"><?php echo e(__('Allowed Absence Days')); ?></label>
                                        <input type="number" name="value" id="allowed_absence_days" class="form-control"
                                               value="<?php echo e($day); ?>">
                                    </div>
                                    <button type="submit" class="btn btn-primary"><?php echo e(__('Save')); ?></button>
                                </form>
                            </div>
                        </div>
                    <?php endif; ?>




                <?php if($page === 'screenshot_protection'): ?>
                        <div class="card">
                            <div class="card-header">
                                <h5 class="mb-0"><?php echo e(__('Screenshot Protection')); ?></h5>
                            </div>
                            <div class="card-body">
                                <?php
                                    $screenshotSetting = $settings->firstWhere('key', 'screenshot_protection');
                                ?>

                                <form method="POST" action="<?php echo e(route('admin.settings.toggle', $screenshotSetting->id)); ?>">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('PATCH'); ?>

                                    <div class="form-group">
                                        <div class="custom-control custom-switch">
                                            <input type="hidden" name="value" value="0"> <!-- For false value -->
                                            <input type="checkbox"
                                                   class="custom-control-input"
                                                   id="screenshotProtection"
                                                   name="value"
                                                   value="1"
                                                   <?php echo e($screenshotSetting->value ? 'checked' : ''); ?>

                                                   onchange="this.form.submit()">
                                            <label class="custom-control-label" for="screenshotProtection">
                                            </label>
                                        </div>
                                        <small class="text-muted d-block mt-2">
                                                                               </small>
                                    </div>
                                </form>
                            </div>
                        </div>
                    <?php endif; ?>


                    <?php if($page === 'fees'): ?>
                        <div class="card">
                            <div class="card-header">
                                <h5 class="mb-0"><?php echo e(__('Fees Protection')); ?></h5>
                            </div>
                            <div class="card-body">
                                <?php
                                    $feesSetting = $settings->firstWhere('key', 'fees');
                                ?>

                                <form method="POST" action="<?php echo e(route('admin.settings.fees', $feesSetting->id)); ?>">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('PATCH'); ?>

                                    <div class="form-group">
                                        <div class="custom-control custom-switch">
                                            <input type="hidden" name="value" value="0"> <!-- For false value -->
                                            <input type="checkbox"
                                                   class="custom-control-input"
                                                   id="fees"
                                                   name="value"
                                                   value="1"
                                                   <?php echo e($feesSetting->value ? 'checked' : ''); ?>

                                                   onchange="this.form.submit()">
                                            <label class="custom-control-label" for="fees">
                                            </label>
                                        </div>
                                        <small class="text-muted d-block mt-2">
                                        </small>
                                    </div>
                                </form>
                            </div>
                        </div>
                    <?php endif; ?>

                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script src="https://cdn.quilljs.com/1.3.6/quill.js"></script>
    <script>
        const toolbarOptions = [
            ['bold', 'italic', 'underline'],
            [{'list': 'ordered'}, {'list': 'bullet'}],
            [{'header': [1, 2, 3, 4, 5, 6, false]}],
            [{'color': []}, {'background': []}],
            ['clean']
        ];

        <?php $__currentLoopData = $settings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $setting): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php if($page === $setting->key && !in_array($page, ['social-media', 'contact-us'])): ?>
            window['quillAr_<?php echo e($setting->key); ?>'] = new Quill('#editorAr_<?php echo e($setting->key); ?>', {
            theme: 'snow',
            modules: { toolbar: toolbarOptions }
        });
        window['quillAr_<?php echo e($setting->key); ?>'].format('align', 'right');
        window['quillAr_<?php echo e($setting->key); ?>'].format('direction', 'rtl');

        window['quillEn_<?php echo e($setting->key); ?>'] = new Quill('#editorEn_<?php echo e($setting->key); ?>', {
            theme: 'snow',
            modules: { toolbar: toolbarOptions }
        });
        window['quillEn_<?php echo e($setting->key); ?>'].format('align', 'left');
        window['quillEn_<?php echo e($setting->key); ?>'].format('direction', 'ltr');
        <?php endif; ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        function submitQuillForm(lang, key) {
            const quill = window['quill' + lang + '_' + key];
            const inputId = 'input' + lang + '_' + key;
            const formId = 'form' + lang + '_' + key;

            document.getElementById(inputId).value = quill.root.innerHTML;
            document.getElementById(formId).submit();
        }


            $(document).ready(function() {
            $('#contact_value').select2({
                tags: true,
                placeholder: "<?php echo e(__('Choose or insert a number')); ?>",
                dir: "rtl"
            });
        });

    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('components.dashboard.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/am2/public_html/resources/views/dashboard/settings/list.blade.php ENDPATH**/ ?>