<!DOCTYPE html>
<html lang="<?php echo e(app()->getLocale()); ?>" dir="<?php echo e(app()->getLocale() === 'ar' ? 'rtl' : 'ltr'); ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo e(__('Delete Account')); ?></title>
    <!-- SweetAlert CSS -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert/dist/sweetalert.css">
    <style>
        /* Inline CSS */
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
            margin: 0;
            padding: 0;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            direction: <?php echo e(app()->getLocale() === 'ar' ? 'rtl' : 'ltr'); ?>;
        }

        .container {
            background: #fff;
            padding: 20px 30px;
            border-radius: 8px;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
            max-width: 400px;
            width: 100%;
        }

        h2 {
            text-align: center;
            margin-bottom: 20px;
            color: #333;
        }

        .form-group {
            margin-bottom: 15px;
        }

        label {
            display: block;
            font-weight: bold;
            margin-bottom: 5px;
            text-align: <?php echo e(app()->getLocale() === 'ar' ? 'right' : 'left'); ?>;
        }

        input {
            width: 100%;
            padding: 10px;
            border: 1px solid #ddd;
            border-radius: 5px;
            text-align: <?php echo e(app()->getLocale() === 'ar' ? 'right' : 'left'); ?>;
        }

        button {
            width: 100%;
            padding: 10px;
            background: #e74c3c;
            color: #fff;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            font-size: 16px;
            font-weight: bold;
        }

        button:hover {
            background: #c0392b;
        }
    </style>
</head>
<body>
<div class="container">
    <h2><?php echo e(__('Delete Account')); ?></h2>
    <form id="deleteAccountForm" action="<?php echo e(route('delete.user.account')); ?>" method="POST">
        <?php echo csrf_field(); ?>
        <div class="form-group">
            <label for="phone"><?php echo e(__('Phone')); ?></label>
            <input type="text" id="phone" name="phone" required placeholder="<?php echo e(__('Enter your phone')); ?>">
            <?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="alert alert-danger mt-2"><?php echo e(__($message)); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
        </div>

        <div class="form-group">
            <label for="password"><?php echo e(__('Password')); ?></label>
            <input type="password" id="password" name="password" required placeholder="<?php echo e(__('Enter your password')); ?>">
            <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="alert alert-danger mt-2"><?php echo e(__($message)); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
        </div>

        <div class="form-group">
            <label for="password_confirmation"><?php echo e(__('Confirm Password')); ?></label>
            <input type="password" id="password_confirmation" name="password_confirmation" required placeholder="<?php echo e(__('Confirm your password')); ?>">
            <?php $__errorArgs = ['password_confirmation'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="alert alert-danger mt-2"><?php echo e(__($message)); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
        </div>

        <button type="button" id="deleteButton"><?php echo e(__('Delete Account')); ?></button>
    </form>
</div>

<!-- SweetAlert JS -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert/dist/sweetalert.min.js"></script>
<script>
    // SweetAlert for Delete Confirmation
    document.getElementById('deleteButton').addEventListener('click', function () {
        swal({
            title: "<?php echo e(__('Are you sure?')); ?>",
            text: "<?php echo e(__('This action will permanently delete your account!')); ?>",
            icon: "warning",
            buttons: [ "<?php echo e(__('Cancel')); ?>", "<?php echo e(__('Yes, delete it!')); ?>" ],
            dangerMode: true,
        }).then((willDelete) => {
            if (willDelete) {
                document.getElementById('deleteAccountForm').submit();
            }
        });
    });

    // SweetAlert for Success Message
    <?php if(session('success')): ?>
    swal({
        title: "<?php echo e(__('Success')); ?>",
        text: "<?php echo e(session('success')); ?>",
        icon: "success",
        timer: 5000,
        buttons: false
    });
    <?php endif; ?>

    // SweetAlert for Error Message
    <?php if(session('error')): ?>
    swal({
        title: "<?php echo e(__('Error')); ?>",
        text: "<?php echo e(session('error')); ?>",
        icon: "error",
        timer: 5000,
        buttons: false
    });
    <?php endif; ?>
</script>
</body>
</html>
<?php /**PATH /home/am2/public_html/resources/views/delete-account.blade.php ENDPATH**/ ?>