<?php $__env->startSection('title', __('Create Quiz')); ?>

<?php $__env->startSection('style'); ?>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <style>
        input[type="checkbox"] {
            appearance: none;
            -webkit-appearance: none;
            width: 18px;
            height: 18px;
            border: 2px solid #999;
            border-radius: 5px;
            cursor: pointer;
            position: relative;
            transition: 0.2s;
        }
        input[type="checkbox"]:checked {
            background-color: #22c55e;
            border-color: #22c55e;
        }
        input[type="checkbox"]:checked::after {
            content: "✔";
            color: #fff;
            font-size: 12px;
            position: absolute;
            top: -2px;
            left: 2px;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="app-content content" id="create-quiz">
        <div class="content-wrapper">
            <?php if (isset($component)) { $__componentOriginalddcd638d544798a22b5064bdbb7bdb0c = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalddcd638d544798a22b5064bdbb7bdb0c = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.dashboard.layouts.breadcrumb','data' => ['now' => ''.e(__('Create Quiz')).'']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('dashboard.layouts.breadcrumb'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['now' => ''.e(__('Create Quiz')).'']); ?>
                 <?php $__env->slot('name', null, []); ?> <?php echo e(__('Quizzes List')); ?> <?php $__env->endSlot(); ?>
                 <?php $__env->slot('route', null, []); ?> <?php echo e(route('teacher.lessons.index')); ?> <?php $__env->endSlot(); ?>
             <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalddcd638d544798a22b5064bdbb7bdb0c)): ?>
<?php $attributes = $__attributesOriginalddcd638d544798a22b5064bdbb7bdb0c; ?>
<?php unset($__attributesOriginalddcd638d544798a22b5064bdbb7bdb0c); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalddcd638d544798a22b5064bdbb7bdb0c)): ?>
<?php $component = $__componentOriginalddcd638d544798a22b5064bdbb7bdb0c; ?>
<?php unset($__componentOriginalddcd638d544798a22b5064bdbb7bdb0c); ?>
<?php endif; ?>

            <?php if(session('errors')): ?>
                <div class="alert alert-danger">
                    <ul>
                        <?php $__currentLoopData = session('errors')->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><?php echo e($error); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            <?php endif; ?>

            <form id="quiz-form" ref="form" action="<?php echo e(route('teacher.lesson.storeQuiz', $lesson->id)); ?>" method="POST" @submit.prevent="handleSubmit">
                <?php echo csrf_field(); ?>
                <input type="hidden" id="lesson_id" name="lesson_id" value="<?php echo e($lesson->id); ?>">

                <div class="card">
                    <div class="card-body row">

                        
                        <div class="form-group col-md-12">
                            <label><?php echo e(__('Quiz Title')); ?></label>
                            <input type="text" name="title" class="form-control" value="<?php echo e(old('title')); ?>" required>
                            <?php $__errorArgs = ['title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <small class="text-danger"><?php echo e($message); ?></small> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        
                        <div class="form-group col-md-6">
                            <label><?php echo e(__('Creation Type')); ?></label>
                            <select name="creation_type" class="form-control" id="creation-type-select" v-model="creation_type">
                                <option value="manual"><?php echo e(__('Manual')); ?></option>
                                <option value="auto"><?php echo e(__('Auto')); ?></option>
                            </select>
                            <?php $__errorArgs = ['creation_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <small class="text-danger"><?php echo e($message); ?></small> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        
                        <div class="form-group col-md-6">
                            <label><?php echo e(__('Duration (minutes)')); ?></label>
                            <input type="number" name="duration" min="1" class="form-control"
                                   value="<?php echo e(old('duration', 10)); ?>" required>
                            <?php $__errorArgs = ['duration'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <small class="text-danger"><?php echo e($message); ?></small> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        
                        <div class="form-group col-md-6">
                            <label><?php echo e(__('Number of Questions')); ?></label>
                            <input type="number"
                                   name="number_of_questions"
                                   id="number-of-questions"
                                   min="1"
                                   class="form-control"
                                   v-model.number="number_of_questions"
                                   value="<?php echo e(old('number_of_questions')); ?>">
                            <?php $__errorArgs = ['number_of_questions'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <small class="text-danger"><?php echo e($message); ?></small> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        
                        <div class="form-group col-md-6">
                            <label for="success_percentage"><?php echo e(__('Success Percentage')); ?> %</label>
                            <input type="number" step="0.01" name="success_percentage" class="form-control"
                                   value="<?php echo e(old('success_percentage')); ?>">
                            <?php $__errorArgs = ['success_percentage'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <small class="text-danger"><?php echo e($message); ?></small> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        
                        <div class="col-md-6 col-12">
                            <div class="form-group">
                                <label for="with_calculator"><?php echo e(__('With Calculator')); ?></label>
                                <select id="with_calculator" name="with_calculator" class="form-control" required>
                                    <option value="1" <?php echo e(old('with_calculator') == '1' ? 'selected' : ''); ?>><?php echo e(__('Active')); ?></option>
                                    <option value="0" <?php echo e(old('with_calculator') == '0' ? 'selected' : ''); ?>><?php echo e(__('Inactive')); ?></option>
                                </select>
                            </div>
                            <?php $__errorArgs = ['with_calculator'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <small class="text-danger"><?php echo e($message); ?></small> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        
                        <div class="col-md-6 col-12">
                            <label for="see_result"><?php echo e(__('See Result')); ?></label>
                            <select name="see_result" class="form-control">
                                <option value="1" <?php echo e(old('see_result') == '1' ? 'selected' : ''); ?>><?php echo e(__('Active')); ?></option>
                                <option value="0" <?php echo e(old('see_result') == '0' ? 'selected' : ''); ?>><?php echo e(__('Inactive')); ?></option>
                            </select>
                            <?php $__errorArgs = ['see_result'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <small class="text-danger"><?php echo e($message); ?></small> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        
                        <div class="col-md-6 col-12 mt-2">
                            <label for="is_question_shuffle"><?php echo e(__('Is Question Shuffle')); ?></label>
                            <select name="is_question_shuffle" class="form-control">
                                <option value="1" <?php echo e(old('is_question_shuffle') == '1' ? 'selected' : ''); ?>><?php echo e(__('Active')); ?></option>
                                <option value="0" <?php echo e(old('is_question_shuffle') == '0' ? 'selected' : ''); ?>><?php echo e(__('Inactive')); ?></option>
                            </select>
                            <?php $__errorArgs = ['is_question_shuffle'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <small class="text-danger"><?php echo e($message); ?></small> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        
                        <div class="col-md-6 col-12 mt-2">
                            <label for="is_answer_shuffle"><?php echo e(__('Is Answers Shuffle')); ?></label>
                            <select name="is_answer_shuffle" class="form-control">
                                <option value="1" <?php echo e(old('is_answer_shuffle') == '1' ? 'selected' : ''); ?>><?php echo e(__('Active')); ?></option>
                                <option value="0" <?php echo e(old('is_answer_shuffle') == '0' ? 'selected' : ''); ?>><?php echo e(__('Inactive')); ?></option>
                            </select>
                            <?php $__errorArgs = ['is_answer_shuffle'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <small class="text-danger"><?php echo e($message); ?></small> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        
                        <div class="col-md-6 col-12 mt-2">
                            <div class="form-group">
                                <label for="with_rules"><?php echo e(__('With Rules')); ?></label>
                                <select id="with_rules" name="with_rules" class="form-control" required>
                                    <option value="1" <?php echo e(old('with_rules') == '1' ? 'selected' : ''); ?>><?php echo e(__('Active')); ?></option>
                                    <option value="0" <?php echo e(old('with_rules') == '0' ? 'selected' : ''); ?>><?php echo e(__('Inactive')); ?></option>
                                </select>
                            </div>
                            <?php $__errorArgs = ['with_rules'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <small class="text-danger"><?php echo e($message); ?></small> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        
                        <div id="auto-question-distribution" class="form-group col-12 row" v-show="creation_type === 'auto'">
                            <div class="col-md-4">
                                <label><?php echo e(__('Easy Questions')); ?></label>
                                <input type="number" min="0" class="form-control" name="easy" v-model.number="auto.easy">
                            </div>
                            <div class="col-md-4">
                                <label><?php echo e(__('Medium Questions')); ?></label>
                                <input type="number" min="0" class="form-control" name="medium" v-model.number="auto.medium">
                            </div>
                            <div class="col-md-4">
                                <label><?php echo e(__('Hard Questions')); ?></label>
                                <input type="number" min="0" class="form-control" name="hard" v-model.number="auto.hard">
                            </div>
                            <div class="col-12 mt-2">
                                <small class="text-danger" v-show="autoSumError"><?php echo e(__('The total must equal the number of questions.')); ?></small>
                            </div>
                        </div>

                        
                        <div class="form-group col-12" id="questions-search" v-show="creation_type === 'manual'">
                            <h5 class="mb-2"><?php echo e(__('Select Questions')); ?></h5>
                            <p class="text-muted">({{ selected_questions.length }} / {{ maxQuestions }})</p>

                            <div class="overflow-x-auto border rounded shadow-sm">
                                <table class="min-w-full w-100 divide-y divide-gray-200 bg-white text-sm text-left">
                                    <thead style="background-color: rgb(248 248 248)">
                                    <tr>
                                        <th class="px-4 py-2 text-center"><?php echo e(__('Select')); ?></th>
                                        <th class="px-4 py-2"><?php echo e(__('Question & Answers')); ?></th>
                                    </tr>
                                    </thead>
                                    <tbody class="divide-y divide-gray-100">
                                    <tr v-for="q in questions" :key="q.id" class="hover:bg-gray-50 transition">
                                        <!-- Checkbox -->
                                        <td class="text-center align-top p-3">
                                            <input type="checkbox"
                                                   :value="q.id"
                                                   :checked="selected_questions.includes(q.id)"
                                                   :disabled="isAtLimit && !selected_questions.includes(q.id)"
                                                   @change="toggleQuestion($event, q.id)">
                                        </td>

                                        <!-- Question + Answers + Details -->
                                        <td class="px-4 py-3">
                                            <div class="flex items-start gap-6">

                                                <!-- Question + Image -->
                                                <div class="flex flex-col items-start w-[320px]">
                                                    <p class="font-semibold mb-3 text-gray-800 text-lg">{{ q.question_text }}</p>
                                                    <img v-if="q.image" :src="q.image"
                                                         class="w-[300px] h-[300px] rounded-xl border shadow object-contain cursor-pointer hover:scale-105 transition"
                                                         @click="showImage(q.image)">
                                                </div>

                                                <!-- Answers -->
                                                <div class="flex-1">
                                                    <!-- MCQ Options -->
                                                    <div v-if="q.question_type === 'mcq'" class="grid grid-cols-2 gap-3">
                                                        <div v-for="opt in q.options" :key="opt.id"
                                                             class="relative p-3 rounded-lg border text-sm shadow-sm"
                                                             :class="opt.is_correct ? 'bg-green-50 border-green-400 font-semibold text-green-900' : 'bg-gray-50 border-gray-200'">
                                                            <span v-if="opt.is_correct"
                                                                  class="absolute top-1 right-1 bg-green-600 text-white text-[10px] px-2 py-0.5 rounded-full shadow">
                                                                <?php echo e(__('Correct')); ?>

                                                            </span>
                                                            <div class="flex items-center gap-2">
                                                                <i class="fa fa-circle"
                                                                   :class="opt.is_correct ? 'text-green-600' : 'text-gray-400'"></i>
                                                                {{ opt.answer }}
                                                            </div>
                                                            <img v-if="opt.image" :src="opt.image"
                                                                 class="mt-2 w-14 h-14 rounded-full border object-cover mx-auto shadow">
                                                        </div>
                                                    </div>

                                                    <!-- Expected Answer (non-MCQ) -->
                                                    <div v-else-if="q.answer"
                                                         class="px-3 py-2 mt-3 rounded-lg bg-purple-100 text-purple-800 font-medium w-fit shadow">
                                                        <?php echo e(__('Expected:')); ?> {{ q.answer }}
                                                    </div>
                                                </div>

                                                <!-- Details -->
                                                <div class="flex flex-col gap-3 text-xs min-w-[120px]">
                                                    <span class="px-2 py-1 rounded-full bg-green-100 text-green-700 font-medium text-center shadow">
                                                        {{ (q.question_type || '').toUpperCase() }}
                                                    </span>
                                                    <span class="px-2 py-1 rounded-full bg-blue-100 text-blue-700 text-center shadow">
                                                        <?php echo e(__('Difficulty:')); ?> {{ q.difficulty_level }}
                                                    </span>
                                                    <span class="px-2 py-1 rounded-full bg-yellow-100 text-yellow-700 text-center shadow">
                                                        <?php echo e(__('Score:')); ?> {{ q.score }}
                                                    </span>
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                    </tbody>
                                </table>
                            </div>

                            <!-- Server pagination -->
                            <nav aria-label="Pagination" class="p-2">
                                <ul class="pagination pagination-sm">
                                    <li class="page-item" :class="{ disabled: current_page === 1 }">
                                        <a class="page-link" href="#" @click.prevent="changePage(current_page - 1)">«</a>
                                    </li>
                                    <li v-for="page in pages" :key="page" class="page-item" :class="{ active: page === current_page }">
                                        <a class="page-link" href="#" @click.prevent="changePage(page)">{{ page }}</a>
                                    </li>
                                    <li class="page-item" :class="{ disabled: current_page === last_page }">
                                        <a class="page-link" href="#" @click.prevent="changePage(current_page + 1)">»</a>
                                    </li>
                                </ul>
                                <div class="text-muted px-2" v-if="total">
                                    <?php echo e(__('Showing')); ?> {{ from }}–{{ to }} <?php echo e(__('of')); ?> {{ total }}
                                </div>
                            </nav>
                        </div>

                        <!-- Hidden inputs for manual selection -->
                        <div id="hidden-question-inputs" v-show="creation_type === 'manual'">
                            <input v-for="id in selected_questions" type="hidden" name="questions[]" :value="id">
                        </div>

                        <div class="form-group col-12 text-end mt-4">
                            <button class="btn btn-success" type="submit"><?php echo e(__('Create Quiz')); ?></button>
                        </div>

                    </div>
                </div>
            </form>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://cdn.jsdelivr.net/npm/vue@2/dist/vue.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/axios/dist/axios.min.js"></script>

    <script>
        new Vue({
            el: '#create-quiz',
            data: {
                creation_type: <?php echo json_encode(old('creation_type', 'manual'), 512) ?>,

                // current page items from the API (no client slicing)
                questions: [],

                // server-side pagination state
                current_page: 1,
                last_page: 1,
                per_page: 0,
                total: 0,
                from: 0,
                to: 0,

                // selection + limits
                selected_questions: <?php echo json_encode(old('questions', []), 512) ?>,
                number_of_questions: parseInt(<?php echo json_encode(old('number_of_questions', 0), 512) ?>) || 0,

                // auto mode numbers
                auto: {
                    easy: parseInt(<?php echo json_encode(old('easy', 0), 512) ?>) || 0,
                    medium: parseInt(<?php echo json_encode(old('medium', 0), 512) ?>) || 0,
                    hard: parseInt(<?php echo json_encode(old('hard', 0), 512) ?>) || 0,
                },
            },
            computed: {
                pages() {
                    const pages = [];
                    for (let i = 1; i <= (this.last_page || 1); i++) pages.push(i);
                    return pages;
                },
                maxQuestions() {
                    return this.number_of_questions || 0;
                },
                isAtLimit() {
                    return this.maxQuestions && this.selected_questions.length >= this.maxQuestions;
                },
                autoSum() {
                    return (this.auto.easy || 0) + (this.auto.medium || 0) + (this.auto.hard || 0);
                },
                autoSumError() {
                    return this.creation_type === 'auto' && this.maxQuestions && (this.autoSum !== this.maxQuestions);
                }
            },
            methods: {
                /**
                 * Fetch a specific page from the API.
                 * Supports common Laravel pagination shapes:
                 *  - { data: [...], meta: {current_page, last_page, per_page, total, from, to} }
                 *  - { data: { data: [...], current_page, last_page, per_page, total, from, to } }
                 */
                loadQuestions(page = 1) {
                    const lessonId = document.getElementById('lesson_id').value;
                    axios.get(`/teacher/lesson-question/${lessonId}`, { params: { page } })
                        .then(res => {
                            const root = res.data ?? {};
                            // Extract list safely
                            let list;
                            if (Array.isArray(root.data)) {
                                list = root.data;
                            } else if (Array.isArray(root)) {
                                list = root;
                            } else if (root.data && Array.isArray(root.data.data)) {
                                list = root.data.data;
                            } else {
                                list = [];
                            }

                            // Extract meta safely
                            const meta = root.meta || root.data || {};
                            this.current_page = meta.current_page ?? page;
                            this.last_page   = meta.last_page   ?? 1;
                            this.per_page    = meta.per_page    ?? (list.length || 0);
                            this.total       = meta.total       ?? (meta.total_items || list.length || 0);
                            this.from        = meta.from        ?? ((this.current_page - 1) * this.per_page + (list.length ? 1 : 0));
                            this.to          = meta.to          ?? (this.from + list.length - 1);

                            this.questions = list || [];
                        })
                        .catch(() => {
                            this.questions = [];
                            this.current_page = 1;
                            this.last_page = 1;
                            this.per_page = 0;
                            this.total = 0;
                            this.from = 0;
                            this.to = 0;
                        });
                },
                changePage(page) {
                    if (page < 1 || page > (this.last_page || 1) || page === this.current_page) return;
                    this.loadQuestions(page);
                },
                toggleQuestion(e, id) {
                    const max = this.maxQuestions;

                    if (e.target.checked) {
                        if (max && this.selected_questions.length >= max) {
                            e.target.checked = false;
                            Swal.fire({
                                icon: 'warning',
                                title: '<?php echo e(__("Limit reached")); ?>',
                                text: '<?php echo e(__("You can only select :count questions.")); ?>'.replace(':count', max),
                                timer: 1800,
                                showConfirmButton: false
                            });
                            return;
                        }
                        if (!this.selected_questions.includes(id)) {
                            this.selected_questions.push(id);
                        }
                    } else {
                        this.selected_questions = this.selected_questions.filter(q => q !== id);
                    }
                },
                showImage(src) {
                    Swal.fire({
                        imageUrl: src,
                        imageWidth: '90%',
                        imageAlt: 'Question Image',
                        background: '#fff',
                        showConfirmButton: false,
                        showCloseButton: true,
                    });
                },
                handleSubmit() {
                    const max = this.maxQuestions;

                    if (!max || max < 1) {
                        Swal.fire({ icon: 'error', title: '<?php echo e(__("Missing number")); ?>', text: '<?php echo e(__("Please set the number of questions first.")); ?>' });
                        return;
                    }

                    if (this.creation_type === 'manual') {
                        if (this.selected_questions.length > max) {
                            Swal.fire({
                                icon: 'error',
                                title: '<?php echo e(__("Too many questions")); ?>',
                                text: '<?php echo e(__("You selected :sel, but the limit is :max.")); ?>'
                                    .replace(':sel', this.selected_questions.length)
                                    .replace(':max', max)
                            });
                            return;
                        }
                        // Require exactly N? Uncomment:
                        // if (this.selected_questions.length !== max) { ... return; }
                    } else if (this.creation_type === 'auto') {
                        if (this.autoSumError) {
                            Swal.fire({
                                icon: 'error',
                                title: '<?php echo e(__("Invalid distribution")); ?>',
                                text: '<?php echo e(__("The sum of easy, medium and hard must equal :max.")); ?>'.replace(':max', max)
                            });
                            return;
                        }
                    }

                    this.$refs.form.submit();
                }
            },
            watch: {
                number_of_questions(newMax) {
                    newMax = parseInt(newMax || 0);
                    if (this.creation_type === 'manual' && newMax && this.selected_questions.length > newMax) {
                        this.selected_questions = this.selected_questions.slice(0, newMax);
                        Swal.fire({
                            icon: 'info',
                            title: '<?php echo e(__("Selection trimmed")); ?>',
                            text: '<?php echo e(__("We trimmed your selection to the new limit of :max.")); ?>'.replace(':max', newMax),
                            timer: 1500,
                            showConfirmButton: false
                        });
                    }
                },
                creation_type(newVal) {
                    if (newVal === 'manual' && this.questions.length === 0) {
                        this.loadQuestions(1);
                    }
                }
            },
            mounted() {
                if (this.creation_type === 'manual') {
                    this.loadQuestions(1);
                }
            }
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('components.dashboard.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/am2/public_html/resources/views/dashboard/lessons/create-quiz.blade.php ENDPATH**/ ?>