<?php $__env->startSection('title', __('Question Details')); ?>

<?php $__env->startSection('styles'); ?>
    <style>
        .question-title {
            font-size: 1.5rem;
            font-weight: bold;
            letter-spacing: 0.5px;
            color: white;
            margin: 0;
        }
         #imageModal {
             display: none;
             position: fixed;
             z-index: 10000;
             left: 0; top: 0;
             width: 100%;
             height: 100%;
             background-color: rgba(0,0,0,0.8);
             justify-content: center;
             align-items: center;
         }
        #imageModal img {
            max-width: 90%;
            max-height: 90%;
            border-radius: 8px;
            box-shadow: 0 0 20px rgba(0,0,0,0.7);
        }
        #imageModal.show {
            display: flex;
        }
        #imageModal .closeBtn {
            position: absolute;
            top: 20px;
            right: 30px;
            font-size: 40px;
            color: white;
            cursor: pointer;
            font-weight: bold;
            user-select: none;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="app-content content">
        <div class="content-wrapper">
            <div class="content-body">

                <?php if (isset($component)) { $__componentOriginalddcd638d544798a22b5064bdbb7bdb0c = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalddcd638d544798a22b5064bdbb7bdb0c = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.dashboard.layouts.breadcrumb','data' => ['now' => ''.e(__('Question Details')).'']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('dashboard.layouts.breadcrumb'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['now' => ''.e(__('Question Details')).'']); ?>
                    <li class="breadcrumb-item">
                        <a href="<?php echo e(route('teacher.questions-bank.index')); ?>"><?php echo e(__('Questions bank')); ?></a>
                    </li>
                 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalddcd638d544798a22b5064bdbb7bdb0c)): ?>
<?php $attributes = $__attributesOriginalddcd638d544798a22b5064bdbb7bdb0c; ?>
<?php unset($__attributesOriginalddcd638d544798a22b5064bdbb7bdb0c); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalddcd638d544798a22b5064bdbb7bdb0c)): ?>
<?php $component = $__componentOriginalddcd638d544798a22b5064bdbb7bdb0c; ?>
<?php unset($__componentOriginalddcd638d544798a22b5064bdbb7bdb0c); ?>
<?php endif; ?>

                <section id="question-details" class="mt-3">
                    <div class="row justify-content-center">
                        <div class="col-md-10">
                            <div class="card shadow rounded" >
                                <div class="card-header bg-primary d-flex justify-content-center" style="padding-bottom: 20px;">
                                    <h5 class="question-title"><?php echo e(__('Question Details')); ?></h5>
                                </div>

                                <div class="card-body">

                                    <div class="row mb-3">
                                        <div class="col-md-6">
                                            <strong><?php echo e(__('Course name')); ?>:</strong>
                                            <p><?php echo e($questionBank->lesson->course->title ?? '-'); ?></p>
                                        </div>
                                        <div class="col-md-6">
                                            <strong><?php echo e(__('Lesson Name')); ?>:</strong>
                                            <p><?php echo e($questionBank->lesson->title ?? '-'); ?></p>
                                        </div>
                                    </div>

                                    <div class="mb-3">
                                        <strong><?php echo e(__('Question Text')); ?>:</strong>
                                        <p><?php echo e($questionBank->question_text); ?></p>
                                    </div>

                                    <?php if($questionBank->getFirstMediaUrl('image')): ?>
                                        <img
                                            id="thumbnailImage"
                                            src="<?php echo e($questionBank->getFirstMediaUrl('image')); ?>"
                                            alt="Question Image"
                                            style="max-width: 300px; cursor: pointer; border-radius: 8px;"
                                            onclick="openModal()"
                                        >
                                    <?php endif; ?>

                                    <div id="imageModal" onclick="closeModal(event)">
                                        <span class="closeBtn" onclick="closeModal(event)">&times;</span>
                                        <img id="modalImg" src="" alt="Expanded Image" onclick="event.stopPropagation()">
                                    </div>

                                    <div class="row mb-3">
                                        <div class="col-md-4">
                                            <strong><?php echo e(__('Question Type')); ?>:</strong><br>
                                            <span class="badge bg-primary"><?php echo e(__($questionBank->question_type)); ?></span>
                                        </div>

                                        <div class="col-md-4">
                                            <strong><?php echo e(__('Question Score')); ?>:</strong><br>
                                            <span class="badge bg-primary"><?php echo e($questionBank->score); ?></span>
                                        </div>

                                        <div class="col-md-4">
                                            <strong><?php echo e(__('Difficulty Level')); ?>:</strong><br>
                                            <?php
                                                $iconClass = match($questionBank->difficulty_level) {
                                                    'easy' => 'fa-circle-check text-success',
                                                    'medium' => 'fa-circle-half-stroke text-warning',
                                                    'hard' => 'fa-circle-xmark text-danger',
                                                    default => 'fa-circle-question text-muted',
                                                };
                                            ?>
                                            <i class="fas <?php echo e($iconClass); ?>"></i>
                                            <span><?php echo e(__($questionBank->difficulty_level)); ?></span>
                                        </div>
                                    </div>

                                    <?php if($questionBank->question_type === 'mcq' && $questionBank->options): ?>
                                        <div class="mb-3">
                                            <strong><?php echo e(__('Choices')); ?>:</strong>
                                            <ul class="list-group mt-2">
                                                <?php $__currentLoopData = $questionBank->options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <li class="list-group-item"
                                                        style="<?php echo e($option->is_correct ? 'background-color: #d4edda; border-color: #28a745;' : ''); ?>">

                                                        <!-- Answer text -->
                                                        <div class="answer-text mb-1 text-dark">
                                                            <strong><?php echo e(__('Answer')); ?>:</strong> <?php echo e($option->answer); ?>

                                                        </div>

                                                        <!-- Answer image if exists -->
                                                        <?php if($option->getFirstMediaUrl('answers_image')): ?>
                                                            <img src="<?php echo e($option->getFirstMediaUrl('answers_image')); ?>"
                                                                 alt="Answer Image"
                                                                 class="img-thumbnail mb-2"
                                                                 style="max-width: 150px;">
                                                        <?php endif; ?>

                                                        <!-- Comment section -->
                                                        <?php if($option->comment): ?>
                                                            <div class="option-comment p-2 border rounded" style="background-color: #f8f9fa;">
                                                                <strong><?php echo e(__('Comment')); ?>:</strong>
                                                                <p class="mb-0 text-dark"><?php echo e($option->comment); ?></p>
                                                            </div>
                                                        <?php endif; ?>

                                                    </li>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                                            </ul>
                                        </div>
                                    <?php elseif($questionBank->answer): ?>
                                           <div class="mb-3">
                                               <strong><?php echo e(__('Answer')); ?>:</strong>
                                               <p><?php echo e($questionBank->answer); ?></p>
                                           </div>
                                           <div class="mb-9">
                                               <strong><?php echo e(__('Comment')); ?>:</strong>
                                               <p><?php echo e($questionBank->comment); ?></p>
                                           </div>
                                    <?php endif; ?>

                                </div>
                            </div>
                        </div>
                    </div>
                </section>

            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script>
        function openModal() {
            const modal = document.getElementById('imageModal');
            const modalImg = document.getElementById('modalImg');
            const thumbnail = document.getElementById('thumbnailImage');
            modalImg.src = thumbnail.src;
            modal.classList.add('show');
        }

        function closeModal(event) {
            event.stopPropagation();
            const modal = document.getElementById('imageModal');
            modal.classList.remove('show');
            document.getElementById('modalImg').src = '';
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('components.dashboard.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/am2/public_html/resources/views/dashboard/questions-bank/show.blade.php ENDPATH**/ ?>