<?php $__env->startSection('styles'); ?>
    <?php echo $__env->yieldPushContent('datatableStyles'); ?>
    <style>
        /* ===== Installment Form Styles ===== */
        .installment-form .form-label{font-weight:600;}
        .installment-form .form-control,
        .installment-form .form-select{height:44px;}
        .installment-form .form-control[readonly],
        .installment-form .form-control:disabled{
            background:#f5f7fb; cursor:not-allowed; color:#6e6b7b;
        }
        .installment-form .mb-1{margin-bottom:1rem !important;}
        .installment-form .hint{font-size:.86rem; color:#8a8d93;}
        .installment-form .card-header{border-bottom:1px solid #ebe9f1;}
        .installment-form .btn{min-width:140px}
        .installment-form .form-check-input{ width:3rem; height:1.5rem; }
        .installment-form .form-check-input:checked{ background-color:#7367F0; border-color:#7367F0; }
        @media (max-width:576px){ .installment-form .btn{width:100%} }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('title'); ?>
    <?php echo e(__('Edit installment')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="app-content content">
        <div class="content-overlay"></div>
        <div class="header-navbar-shadow"></div>
        <div class="content-wrapper">
            <div class="content-header row"></div>
            <div class="content-body">

                <section class="users-list-wrapper">
                    <?php if (isset($component)) { $__componentOriginalddcd638d544798a22b5064bdbb7bdb0c = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalddcd638d544798a22b5064bdbb7bdb0c = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.dashboard.layouts.breadcrumb','data' => ['now' => ''.e(__('Edit installment')).'']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('dashboard.layouts.breadcrumb'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['now' => ''.e(__('Edit installment')).'']); ?> <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalddcd638d544798a22b5064bdbb7bdb0c)): ?>
<?php $attributes = $__attributesOriginalddcd638d544798a22b5064bdbb7bdb0c; ?>
<?php unset($__attributesOriginalddcd638d544798a22b5064bdbb7bdb0c); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalddcd638d544798a22b5064bdbb7bdb0c)): ?>
<?php $component = $__componentOriginalddcd638d544798a22b5064bdbb7bdb0c; ?>
<?php unset($__componentOriginalddcd638d544798a22b5064bdbb7bdb0c); ?>
<?php endif; ?>

                    <section id="installment-edit" class="installment-form">
                        <div class="row">
                            <div class="col-12">
                                <div class="card">
                                    <div class="card-header d-flex justify-content-between align-items-center">
                                        <h4 class="card-title mb-0"><?php echo e(__('Edit installment')); ?></h4>
                                    </div>

                                    <div class="card-content">
                                        <div class="card-body">
                                            <form method="POST" action="<?php echo e(route('teacher.installments.update', $installment->id)); ?>">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('PUT'); ?>

                                                
                                                <input type="hidden" name="course_id" value="<?php echo e($installment->course_id); ?>">

                                                <div class="row">
                                                    
                                                    <div class="col-md-6 mb-1">
                                                        <label class="form-label"><?php echo e(__('Amount')); ?> <span class="text-danger">*</span></label>
                                                        <input type="number" step="0.01" min="0" name="amount"
                                                               value="<?php echo e(old('amount', $installment->amount)); ?>"
                                                               class="form-control <?php $__errorArgs = ['amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" required>
                                                        <?php $__errorArgs = ['amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><div class="invalid-feedback"><?php echo e($message); ?></div><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                    </div>

                                                    
                                                    <div class="col-md-6 mb-1"
                                                         style="display: <?php echo e((int) old('is_final', $installment->is_final) === 1 ? 'none' : 'block'); ?>;">
                                                        <label class="form-label"><?php echo e(__('Minimum amount')); ?></label>
                                                        <input type="number" step="0.01" min="0" name="minimum_amount"
                                                               value="<?php echo e(old('minimum_amount', $installment->minimum_amount)); ?>"
                                                               class="form-control <?php $__errorArgs = ['minimum_amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                                                        <small class="hint"><?php echo e(__('Optional: minimum amount accepted for this installment')); ?></small>
                                                        <?php $__errorArgs = ['minimum_amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><div class="invalid-feedback"><?php echo e($message); ?></div><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                    </div>

                                                    
                                                    <div class="col-md-6 mb-1">
                                                        <label class="form-label"><?php echo e(__('Due date')); ?> <span class="text-danger">*</span></label>
                                                        <input type="date" name="due_date"
                                                               value="<?php echo e(old('due_date', $installment->due_date)); ?>"
                                                               class="form-control <?php $__errorArgs = ['due_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" required>
                                                        <?php $__errorArgs = ['due_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><div class="invalid-feedback"><?php echo e($message); ?></div><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                    </div>

                                                    
                                                    <div class="col-md-6 mb-1">
                                                        <label class="form-label"><?php echo e(__('Installment number')); ?></label>
                                                        <select class="form-select form-control installment-number <?php $__errorArgs = ['installment_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                                name="installment_number" readonly required>

                                                                <option value="<?php echo e($installment->installment_number); ?>" selected >
                                                                    <?php echo e(\App\Enum\InstallmentNumbersEnum::getInstallmentName($installment->installment_number)); ?>

                                                                </option>

                                                        </select>
                                                        <?php $__errorArgs = ['installment_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><div class="invalid-feedback"><?php echo e($message); ?></div><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                    </div>

                                                    <div class="form-check form-switch mb-1">
                                                        <input type="hidden" name="is_final" value="<?php echo e((int) old('is_final', $installment->is_final)); ?>">

                                                        <input
                                                            class="form-check-input m-2"
                                                            type="checkbox"
                                                            id="is_final_display"
                                                            value="1"
                                                            <?php if((int) old('is_final', $installment->is_final) === 1): echo 'checked'; endif; ?>
                                                            disabled
                                                            aria-disabled="true"
                                                            aria-describedby="is_final_help"
                                                        >
                                                        <label class="form-check-label" for="is_final_display">
                                                            <?php echo e(__('Is final installment?')); ?>

                                                        </label>
                                                    </div>

                                                </div>

                                                    <div class="mt-2 d-flex gap-1 flex-wrap">
                                                    <button type="submit" class="btn btn-primary">
                                                        <?php echo e(__('Update')); ?>

                                                    </button>

                                                 </div>
                                            </form>
                                        </div> 
                                    </div>
                                </div>
                            </div>
                        </div>
                    </section>
                </section>

            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <?php echo $__env->yieldPushContent('datatableScripts'); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('components.dashboard.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/am2/public_html/resources/views/dashboard/installments/edit.blade.php ENDPATH**/ ?>