<?php $__env->startSection('title',__($titleKey)); ?>

<?php $__env->startSection('styles'); ?>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css">
    <style>
        body {
            background-color: #f4f6f9;
        }

        .app-content.content {
            padding: 0 15px 40px;
            background: #fdfdfd;
            border-radius: 10px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.05);
        }

        .card {
            border: none;
            border-radius: 10px;
            margin-bottom: 25px;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.04);
            background-color: #ffffff;
        }

        .card-header {
            background-color: #0A4199;
            color: #fff;
            font-size: 1.5rem;
            font-weight: 700;
            padding: 15px 20px;
            border-bottom: none;
        }

        .card-body {
            padding: 20px 25px;
            background-color: #ffffff;
            font-size: 1.3rem;
        }

        .exam-details-list {
            display: flex;
            flex-wrap: wrap;
            gap: 20px;
            list-style: none;
            padding: 0;
        }

        .exam-details-list li {
            flex: 1 1 calc(50% - 20px);
            background: #f1f4fa;
            padding: 15px;
            border-radius: 8px;
        }

        .stat-box {
            background: #f1f4fa;
            border-radius: 1rem;
            padding: 2rem 1rem;
            box-shadow: inset 0 1px 2px rgba(0, 0, 0, 0.03);
            transition: all 0.3s ease;
            position: relative;
            margin-bottom: 30px;
        }

        .stat-box .icon {
            font-size: 2.2rem;
            color: #0A4199;
        }

        .stat-box h6 {
            font-weight: bold;
            font-size: 1.1rem;
        }

        .stat-box p {
            font-size: 1.25rem;
        }

        ol, ul {
            padding-right: 1rem;
        }
        .btn-student-view {
            background: linear-gradient(135deg, #0A4199, #4e95d3);
            color: #fff;
            font-weight: 700;
            padding: 14px 32px;
            border-radius: 40px;
            font-size: 1.25rem;
            box-shadow: 0 8px 15px rgba(10, 65, 153, 0.3);
            transition: all 0.3s ease;
            text-decoration: none;
            user-select: none;
        }
        .btn-student-view:hover {
            background: linear-gradient(135deg, #083370, #356ab7);
            box-shadow: 0 12px 20px rgba(10, 65, 153, 0.5);
            transform: translateY(-3px);
            text-decoration: none;
            color: #fff;
        }
        .btn-student-view:active {
            transform: translateY(-1px);
            box-shadow: 0 6px 10px rgba(10, 65, 153, 0.2);
        }
        .bounce-icon {
            animation: bounce 1.5s infinite;
        }

        @keyframes bounce {
            0%, 100% {
                transform: translateY(0);
            }

            50% {
                transform: translateY(-5px);
            }
        }

    </style>

<?php $__env->stopSection(); ?>


<?php $__env->startSection('content'); ?>



    <div class="app-content content">
        <div class="content-wrapper">
            <?php if (isset($component)) { $__componentOriginalddcd638d544798a22b5064bdbb7bdb0c = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalddcd638d544798a22b5064bdbb7bdb0c = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.dashboard.layouts.breadcrumb','data' => ['now' => ''.e(__($titleKey)).'']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('dashboard.layouts.breadcrumb'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['now' => ''.e(__($titleKey)).'']); ?>
                <li class="breadcrumb-item">
                    <a href="<?php echo e(route('teacher.quiz.exams.index')); ?>">
                        <?php echo e(__('Quizzes and Exams')); ?>

                    </a>
                </li>
             <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalddcd638d544798a22b5064bdbb7bdb0c)): ?>
<?php $attributes = $__attributesOriginalddcd638d544798a22b5064bdbb7bdb0c; ?>
<?php unset($__attributesOriginalddcd638d544798a22b5064bdbb7bdb0c); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalddcd638d544798a22b5064bdbb7bdb0c)): ?>
<?php $component = $__componentOriginalddcd638d544798a22b5064bdbb7bdb0c; ?>
<?php unset($__componentOriginalddcd638d544798a22b5064bdbb7bdb0c); ?>
<?php endif; ?>

            <div class="card">
                <div class="card-header bg-gradient text-center text-white fs-4 fw-bold d-flex justify-content-center align-items-center"
                     style="background: linear-gradient(90deg, #0A4199, #4e95d3); padding: 12px 0;">
                    <i class="bi bi-file-earmark-text me-2 mx-1"></i> <?php echo e(__($titleKey)); ?>

                </div>

                <div class="card-body">
                    <ul class="exam-details-list row">
                              <li class="col-sm-12 col-md-6 mt-2"><strong><?php echo e(__('Title')); ?>:</strong> <?php echo e($item->title); ?></li>
                               <li class="col-sm-12 col-md-6 mt-2"><strong><?php echo e(__('Number Of Questions')); ?>:</strong> <?php echo e($item->number_of_questions); ?></li>
                        <?php if(isset($item->start_time)): ?>
                               <li class="col-sm-12 col-md-6 mt-2"><strong><?php echo e(__('Start Date')); ?>:</strong> <?php echo e($item?->start_time ?? ''); ?></li>
                        <?php endif; ?>
                        <?php if(isset($item->end_time)): ?>
                                <li class="col-sm-12 col-md-6 mt-2"><strong><?php echo e(__('End Date')); ?>:</strong> <?php echo e($item?->end_time ?? ''); ?></li>
                        <?php endif; ?>

                        <li class="col-sm-12 col-md-6 mt-2"><strong><?php echo e(__('Duration')); ?>:</strong> <?php echo e($item->duration); ?> دقيقة</li>
                        <?php if(isset($item->creation_type)): ?>
                                <li class="col-sm-12 col-md-6 mt-2"><strong><?php echo e(__('Questions Order')); ?>:</strong>
                                   <?php echo e(__($item->creation_type)); ?>

                                </li>
                        <?php endif; ?>
                            <?php if(!empty($item->description)): ?>
                                <li class="col-sm-12 col-md-12 mt-2"><strong><?php echo e(__('Description')); ?></strong> <?php echo e($item->description); ?></li>
                            <?php endif; ?>
                        <?php if(isset($item->success_percentage)): ?>
                            <li class="col-sm-12 col-md-6 mt-2"><strong><?php echo e(__('Success Percentage')); ?>:</strong>
                                <?php echo e(__($item->success_percentage)); ?> %
                            </li>
                        <?php endif; ?>
                        <?php if(isset($item->is_question_shuffle)): ?>
                            <li class="col-sm-12 col-md-6 mt-2">
                                <strong><?php echo e(__('Shuffle Questions')); ?>:</strong>
                                <?php echo e($item->is_question_shuffle ? __('Yes') : __('No')); ?>

                            </li>
                        <?php endif; ?>
                        <?php if(isset($item->see_result)): ?>
                            <li class="col-sm-12 col-md-6 mt-2">
                                <strong><?php echo e(__('See Result')); ?>:</strong>
                                <?php echo e($item->see_result ? __('Yes') : __('No')); ?>

                            </li>
                        <?php endif; ?>

                        <?php if(isset($item->with_rules)): ?>
                            <li class="col-sm-12 col-md-6 mt-2">
                                <strong><?php echo e(__('With Rules')); ?>:</strong>
                                <?php echo e($item->with_rules ? __('Yes') : __('No')); ?>

                            </li>
                        <?php endif; ?>

                        <?php if(isset($item->with_calculator)): ?>
                            <li class="col-sm-12 col-md-6 mt-2">
                                <strong><?php echo e(__('With Calculator')); ?>:</strong>
                                <?php echo e($item->with_calculator ? __('Yes') : __('No')); ?>

                            </li>
                        <?php endif; ?>


                    </ul>
                    <?php
                        $type = $item instanceof \App\Models\Quiz ? 'quiz' : 'exam';
                    ?>


                    <div class="text-center my-4">
                                <a href="<?php echo e(route('teacher.quiz.exams.students.index', ['id' => $item->id, 'type' => $type])); ?>"
                                   class="btn btn-student-view d-inline-flex align-items-center gap-2 shadow-lg px-3 py-1 fs-5"
                                   style="background: linear-gradient(135deg, #1172c2, #38a1f3); border-radius: 50px;">
                                    <i class="bi bi-people-fill fs-4 bounce-icon"></i>
                                    <?php echo e(__('Show Students')); ?>

                                </a>

                            </div>
                    </div>
                </div>


            <div class="card shadow border-0">
                <div class="card-header bg-gradient text-center text-white fs-4 fw-bold d-flex justify-content-center align-items-center"
                     style="background: linear-gradient(90deg, #0A4199, #4e95d3); padding: 12px 0;">
                    <i class="bi bi-graph-up-arrow me-2 mx-1"></i>
                    <?php echo e(__('Success Statistics')); ?>

                </div>

                <?php
                    $hasBasicStats = isset($totalStudents) && isset($passedStudents) && isset($failedStudents);
                    $colClass = $hasBasicStats ? 'col-md-4' : 'col-12';
                ?>

                <div class="card-body">
                    <div class="row g-4 text-center">
                        <?php if(isset($totalStudents)): ?>
                            <div class="<?php echo e($colClass); ?>">
                                <div class="stat-box border-top border-primary border-4">
                                    <i class="bi bi-people icon text-primary"></i>
                                    <h6><?php echo e(__('Total Students')); ?></h6>
                                    <p><?php echo e($totalStudents); ?></p>
                                </div>
                            </div>
                        <?php endif; ?>

                        <?php if(isset($passedStudents)): ?>
                            <div class="<?php echo e($colClass); ?>">
                                <div class="stat-box border-top border-success border-4">
                                    <i class="bi bi-check-circle icon text-success"></i>
                                    <h6><?php echo e(__('Passed Students')); ?></h6>
                                    <p><?php echo e($passedStudents); ?></p>
                                </div>
                            </div>
                        <?php endif; ?>

                        <?php if(isset($failedStudents)): ?>
                            <div class="<?php echo e($colClass); ?>">
                                <div class="stat-box border-top border-danger border-4">
                                    <i class="bi bi-x-circle icon text-danger"></i>
                                    <h6><?php echo e(__('Failed Students')); ?></h6>
                                    <p><?php echo e($failedStudents); ?></p>
                                </div>
                            </div>
                        <?php endif; ?>

                        
                        <?php
                            // هذه القيم لا تحتاج تغيير الكول، لأنها تظهر فقط لو البيانات موجودة
                            $scoreColClass = 'col-md-4';
                        ?>

                        <?php if(isset($highestScore)): ?>
                            <div class="<?php echo e($scoreColClass); ?>">
                                <div class="stat-box border-top border-warning border-4">
                                    <i class="bi bi-arrow-up icon text-warning"></i>
                                    <h6><?php echo e(__('Highest Score')); ?></h6>
                                    <p><?php echo e(number_format($highestScore, 2)); ?>%</p>
                                </div>
                            </div>
                        <?php endif; ?>

                        <?php if(isset($lowestScore)): ?>
                            <div class="<?php echo e($scoreColClass); ?>">
                                <div class="stat-box border-top border-secondary border-4">
                                    <i class="bi bi-arrow-down icon text-secondary"></i>
                                    <h6><?php echo e(__('Lowest Score')); ?></h6>
                                    <p><?php echo e(number_format($lowestScore, 2)); ?>%</p>
                                </div>
                            </div>
                        <?php endif; ?>

                        <?php if(isset($averageScore)): ?>
                            <div class="<?php echo e($scoreColClass); ?>">
                                <div class="stat-box border-top border-info border-4">
                                    <i class="bi bi-bar-chart-line icon text-info"></i>
                                    <h6><?php echo e(__('Average Score')); ?></h6>
                                    <p><?php echo e(number_format($averageScore, 2)); ?>%</p>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <!-- Questions -->


























































































        </div>
    <?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('components.dashboard.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/am2/public_html/resources/views/dashboard/exams/show.blade.php ENDPATH**/ ?>