<?php $__env->startSection('styles'); ?>
    <?php echo $__env->yieldPushContent('datatableStyles'); ?>
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet"/>
    <style>
        .question-block {
            border: 1px solid #d1d5db;
            border-radius: 12px;
            margin-bottom: 30px;
            background-color: #ffffff;
            box-shadow: 0 4px 10px rgb(0 0 0 / 0.05);
            transition: box-shadow 0.3s ease;
            padding-bottom: 20px;
        }

        .question-block:hover {
            box-shadow: 0 8px 24px rgb(0 0 0 / 0.12);
        }

        .question-block .card-header {
            padding: 1rem 1.5rem;
            font-weight: 700;
            font-size: 1.25rem;
            color: #1e293b;
            background-color: #f1f5f9;
            border-bottom: 1px solid #cbd5e1;
            display: flex;
            justify-content: space-between;
            align-items: center;
            border-top-left-radius: 12px;
            border-top-right-radius: 12px;
        }

        .btn-remove-question {
            font-size: 0.9rem;
            padding: 6px 16px;
            background-color: #ef4444;
            border: none;
            color: white;
            border-radius: 8px;
            transition: background-color 0.2s ease;
            cursor: pointer;
            box-shadow: 0 2px 6px rgb(239 68 68 / 0.7);
        }

        .btn-remove-question:hover {
            background-color: #b91c1c;
            box-shadow: 0 3px 8px rgb(185 28 28 / 0.8);
        }

        label.form-label {
            font-weight: 600;
            font-size: 1rem;
            margin-bottom: 6px;
            color: #334155;
            display: block;
        }

        select.form-control,
        input.form-control,
        textarea.form-control {
            font-size: 1rem;
            padding: 12px 14px;
            border-radius: 10px;
            border: 1.8px solid #cbd5e1;
            transition: border-color 0.25s ease, box-shadow 0.25s ease;
            width: 100%;
            box-sizing: border-box;
            background-color: #f9fafb;
            height: 50px;
        }

        select.form-control:focus,
        input.form-control:focus,
        textarea.form-control:focus {
            outline: none;
            border-color: #2563eb;
            box-shadow: 0 0 6px #2563eb88;
            background-color: #ffffff;
        }

        textarea.form-control {
            min-height: 80px;
            resize: vertical;
        }

        .answers-group {
            display: flex;
            flex-direction: column;
            gap: 16px;
            margin-top: 15px;
        }

        .answer-item {
            background: #fff;
            border-radius: 12px;
            border: 1.5px solid #e2e8f0;
            box-shadow: 0 2px 8px rgb(0 0 0 / 0.05);
            display: flex;
            gap: 20px;
            padding: 16px 20px;
            align-items: center;
            transition: border-color 0.3s ease, box-shadow 0.3s ease, background-color 0.3s ease;
            position: relative;
        }

        .answer-item.selected-answer {
            border-color: #22c55e;
            box-shadow: 0 8px 20px rgb(34 197 94 / 0.4);
            background-color: #f0fdf4;
        }

        .answer-text-wrapper {
            flex: 1 1 auto;
            max-width: 65%;
        }

        .answer-text-wrapper textarea {
            width: 100%;
            min-height: 60px;
            resize: vertical;
            padding: 10px 14px;
            border-radius: 10px;
            border: 1.5px solid #cbd5e1;
            font-size: 1rem;
            background-color: #fff;
            transition: border-color 0.3s ease;
        }

        .answer-text-wrapper textarea:focus {
            border-color: #3b82f6;
            box-shadow: 0 0 6px #3b82f688;
            outline: none;
        }

        .answer-file-wrapper {
            flex: 0 0 auto;
            min-width: 180px;
            display: flex;
            justify-content: center;
        }

        .answer-file-wrapper input[type="file"] {
            width: 100%;
            border-radius: 10px;
            border: 1.8px solid #cbd5e1;
            padding: 6px 10px;
            font-size: 0.95rem;
            cursor: pointer;
            background-color: #fff;
        }

        .correct-wrapper {
            flex: 0 0 110px;
            display: flex;
            align-items: center;
            gap: 6px;
            font-weight: 700;
            font-size: 1rem;
            color: #16a34a;
            cursor: pointer;
            user-select: none;
            position: relative;
        }

        .correct-wrapper input[type="radio"] {
            position: absolute;
            opacity: 0;
            pointer-events: none;
        }

        .correct-icon {
            width: 24px;
            height: 24px;
            fill: #94a3b8;
            transition: fill 0.3s ease;
            cursor: pointer;
            flex-shrink: 0;
        }

        .correct-wrapper.selected .correct-icon {
            fill: #16a34a;
        }

        .correct-wrapper:hover .correct-icon {
            fill: #22c55e;
        }

        .btn-primary {
            font-size: 1.1rem;
            padding: 12px 36px;
            border-radius: 12px;
            background-color: #2563eb;
            border: none;
            color: #fff;
            transition: background-color 0.3s ease;
            cursor: pointer;
            box-shadow: 0 3px 8px rgb(37 99 235 / 0.7);
            user-select: none;
        }

        .btn-primary:hover {
            background-color: #1e40af;
            box-shadow: 0 4px 10px rgb(30 64 175 / 0.85);
        }

        #add-question {
            display: block;
            margin: 30px auto 40px auto;
            font-weight: 700;
            letter-spacing: 0.04em;
            max-width: 240px;
        }

        small.text-danger {
            display: block;
            margin-top: 5px;
            font-size: 0.9rem;
            color: #dc2626;
        }

        @media (max-width: 576px) {
            .answer-item {
                flex-direction: column;
            }

            .answer-file-wrapper {
                flex: 1 1 auto;
                margin-top: 12px;
            }

            #add-question {
                max-width: 100%;
            }
        }

        .select2-container .select2-selection--single {
            height: 50px !important;
            border-radius: 10px !important;
            border: 1.8px solid #cbd5e1 !important;
            padding: 6px 12px !important;
            background-color: #f9fafb !important;
            box-sizing: border-box;
            font-size: 1rem !important;
            color: #334155 !important;
        }

        .select2-container--default .select2-selection--single .select2-selection__rendered {
            line-height: 36px !important;
        }

        .select2-container--default .select2-selection--single .select2-selection__arrow {
            height: 50px !important;
            right: 10px !important;
        }

        .answer-item.essay-item {
            flex-direction: column;
            align-items: stretch;
        }

        .answer-item.essay-item .answer-text-wrapper {
            max-width: 100%;
            flex: 1 1 100%;
        }

        .btn-remove-question {
            font-size: 1.4rem;
            color: #ef4444;
            background: transparent;
            cursor: pointer;
            line-height: 1;
        }

        .btn-remove-question:hover {
            color: #b91c1c;
        }
        .answer-block.selected-answer {
            border: 2px solid #28a745;
            background: #e9f9ef;
            border-radius: 6px;
            padding: 10px;
        }

        .comment-text-wrapper {
            padding-left: 0 !important;
            padding-right: 0 !important;
        }


        .comment-text-wrapper textarea.form-control {
            padding: 2px 5px;
        }


    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('title'); ?>
    <?php echo e(__('Add Question')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="app-content content">
        <div class="content-wrapper">
            <div class="content-body">
                <?php if (isset($component)) { $__componentOriginalddcd638d544798a22b5064bdbb7bdb0c = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalddcd638d544798a22b5064bdbb7bdb0c = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.dashboard.layouts.breadcrumb','data' => ['now' => ''.e(__('Add Question')).'']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('dashboard.layouts.breadcrumb'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['now' => ''.e(__('Add Question')).'']); ?>
                    <li class="breadcrumb-item"><a
                            href="<?php echo e(route('teacher.questions-bank.index')); ?>"><?php echo e(__('Questions bank')); ?></a></li>
                 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalddcd638d544798a22b5064bdbb7bdb0c)): ?>
<?php $attributes = $__attributesOriginalddcd638d544798a22b5064bdbb7bdb0c; ?>
<?php unset($__attributesOriginalddcd638d544798a22b5064bdbb7bdb0c); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalddcd638d544798a22b5064bdbb7bdb0c)): ?>
<?php $component = $__componentOriginalddcd638d544798a22b5064bdbb7bdb0c; ?>
<?php unset($__componentOriginalddcd638d544798a22b5064bdbb7bdb0c); ?>
<?php endif; ?>
               <?php if (isset($component)) { $__componentOriginaledc6e21ff76190394fdb85a398f88863 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginaledc6e21ff76190394fdb85a398f88863 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.validation.questions-validation','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('validation.questions-validation'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginaledc6e21ff76190394fdb85a398f88863)): ?>
<?php $attributes = $__attributesOriginaledc6e21ff76190394fdb85a398f88863; ?>
<?php unset($__attributesOriginaledc6e21ff76190394fdb85a398f88863); ?>
<?php endif; ?>
<?php if (isset($__componentOriginaledc6e21ff76190394fdb85a398f88863)): ?>
<?php $component = $__componentOriginaledc6e21ff76190394fdb85a398f88863; ?>
<?php unset($__componentOriginaledc6e21ff76190394fdb85a398f88863); ?>
<?php endif; ?>

                <section id="basic-input" class="mt-3">
                    <div class="row justify-content-center">
                        <div class="col-xl-10 col-lg-11 col-md-12 col-12">
                            <form id="myForm" action="<?php echo e(route('teacher.questions-bank.store')); ?>" method="POST"
                                  enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>

                                <div class="question-block">
                                    <div class="card-header">
                                        <h5><?php echo e(__('Question')); ?></h5>
                                    </div>
                                    <div class="card-body">
                                        <div class="row mb-3">
                                            <div class="col-md-6">
                                                <label for="question_type"><?php echo e(__('Course name')); ?></label>
                                                <select id="course-select" class="form-control select2 course-select"
                                                        name="course_id">
                                                    <option value=""><?php echo e(__('Select Course')); ?></option>
                                                    <?php $__currentLoopData = $courses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $id => $title): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option
                                                            value="<?php echo e($id); ?>" <?php echo e(old('course_id') == $id ? 'selected' : ''); ?>><?php echo e($title); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                                <?php $__errorArgs = ['course_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <small class="text-danger"><?php echo e($message); ?></small>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                            <div class="col-md-6">
                                                <label for="question_type"><?php echo e(__('Lesson name')); ?></label>
                                                <select id="lesson-select" class="form-control select2 lesson-select"
                                                        name="lesson_id">
                                                    <option value=""><?php echo e(__('Select Lesson')); ?></option>
                                                    <?php $__currentLoopData = $lessons; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $id => $title): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option
                                                            value="<?php echo e($id); ?>" <?php echo e(old('lesson_id') == $id ? 'selected' : ''); ?>><?php echo e($title); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>

                                                <?php $__errorArgs = ['lesson_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <small class="text-danger"><?php echo e($message); ?></small>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                        </div>

                                        <div class="row mb-3">
                                            <div class="col-md-3">
                                                <label for="question_type"><?php echo e(__('Question Type')); ?></label>
                                                <select id="question_type" name="question_type" class="form-control">
                                                    <option value="" disabled><?php echo e(__('Select question type')); ?></option>
                                                    <?php $__currentLoopData = \App\Enum\QuestionTypeEnum::getValues(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $question): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option
                                                            value="<?php echo e($question); ?>" <?php echo e(old('question_type', 'Grid-in') == $question ? 'selected' : ''); ?>>
                                                            <?php echo e(__($question)); ?>

                                                        </option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>

                                                <?php $__errorArgs = ['question_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <small class="text-danger"><?php echo e($message); ?></small>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                            <div class="col-md-3">
                                                <label for="difficulty_level"><?php echo e(__('difficulty_level')); ?></label>
                                                <select id="difficulty_level" name="difficulty_level"
                                                        class="form-control">
                                                    <option value="" disabled
                                                            selected><?php echo e(__('Select difficulty_level')); ?></option>
                                                    <?php $__currentLoopData = \App\Enum\QuestionDifficultyEnum::getValues(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $difficulty_level): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option
                                                            value="<?php echo e($difficulty_level); ?>" <?php echo e(old('difficulty_level') == $difficulty_level ? 'selected' : ''); ?>><?php echo e(__($difficulty_level)); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                                <?php $__errorArgs = ['difficulty_level'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <small class="text-danger"><?php echo e($message); ?></small>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                            <div class="col-md-3">
                                                <label for="score"><?php echo e(__('Question Score')); ?></label>
                                                <input id="score" type="number" min="0" step="0.5" name="score"
                                                       class="form-control"
                                                       placeholder="<?php echo e(__('Enter Question Score')); ?>"
                                                       value="<?php echo e(old('score')); ?>">
                                                <?php $__errorArgs = ['score'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <small class="text-danger"><?php echo e($message); ?></small>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                            <div class="col-md-3">
                                                <label for="question_image"><?php echo e(__('Question Image')); ?></label>
                                                <input id="question_image" type="file" name="question_image"
                                                       accept="image/*" class="form-control p-1"
                                                       aria-describedby="imageHelp_0">
                                                <?php $__errorArgs = ['question_image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <small class="text-danger"><?php echo e($message); ?></small>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                        </div>

                                        <div class="mb-3">
                                            <label for="question_text"><?php echo e(__('Question Text')); ?></label>
                                            <textarea id="question_text" name="question_text" class="form-control"
                                                      rows="3"
                                                      placeholder="<?php echo e(__('Enter the question')); ?>"><?php echo e(old('question_text')); ?></textarea>
                                            <?php $__errorArgs = ['question_text'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <small class="text-danger"><?php echo e($message); ?></small>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>

                                        <hr class="my-4">

                                        <label class="form-label fw-bold"><?php if(\App\Enum\QuestionTypeEnum::GridIn): ?>
                                                <?php echo e(__('Answer')); ?>

                                            <?php else: ?>
                                                <?php echo e(__('Answers')); ?>

                                            <?php endif; ?></label>
                                        <div class="answers-wrapper">
                                            <div class="answers-group">
                                                <?php for($i = 0; $i < 5; $i++): ?>
                                                    <div class="answer-item">
                                                        <div class="answer-text-wrapper">
                                                            <textarea name="answer_<?php echo e($i); ?>_text" class="form-control"
                                                                      placeholder="<?php echo e(__('Answer')); ?> <?php echo e($i + 1); ?>"><?php echo e(old("answer_{$i}_text")); ?></textarea>
                                                            <?php $__errorArgs = ["answer_{$i}_text"];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                            <small class="text-danger"><?php echo e($message); ?></small>
                                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                                        </div>
                                                        <div class="answer-file-wrapper col-4">
                                                            <input type="file" name="answer_<?php echo e($i); ?>_image"
                                                                   accept="image/*" class="form-control p-1"
                                                                   title="<?php echo e(__('Upload image for answer')); ?>">
                                                        </div>
                                                        <div class="correct-wrapper" tabindex="0" role="radio"
                                                             aria-checked="<?php echo e(old('correct_answer') == $i ? 'true' : 'false'); ?>"
                                                             data-radio-id="correct_answer_<?php echo e($i); ?>">
                                                            <input class="correct-radio" type="radio"
                                                                   name="correct_answer" id="correct_answer_<?php echo e($i); ?>"
                                                                   value="<?php echo e($i); ?>" <?php echo e(old('correct_answer') == $i ? 'checked' : ''); ?> >
                                                            <?php $__errorArgs = ["answer_{$i}_image"];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                            <small class="text-danger"><?php echo e($message); ?></small>
                                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                            <svg class="correct-icon" xmlns="http://www.w3.org/2000/svg"
                                                                 viewBox="0 0 24 24" aria-hidden="true"
                                                                 focusable="false">
                                                                <path
                                                                    d="M20.285 6.709a1 1 0 0 0-1.414-1.418l-9.192 9.199-4.192-4.2a1 1 0 0 0-1.415 1.415l4.9 4.906a1 1 0 0 0 1.414 0l9.899-9.902z"/>
                                                            </svg>
                                                            <span><?php echo e(__('Correct')); ?></span>
                                                        </div>
                                                    </div>
                                                    <div class="answer-item">
                                                        <div class="answer-text-wrapper">
                                                            <textarea name="comment_<?php echo e($i); ?>_text" class="form-control"
                                                                      placeholder="<?php echo e(__('Comment')); ?> <?php echo e($i + 1); ?>"><?php echo e(old("comment_{$i}_text")); ?></textarea>
                                                            <?php $__errorArgs = ["comment_{$i}_text"];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                            <small class="text-danger"><?php echo e($message); ?></small>
                                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                                        </div>
                                                    </div>
                                                <?php endfor; ?>
                                            </div>

                                        </div>
                                    </div>
                                </div>

                                <div class="col-xl-10 col-lg-11 col-md-12 col-12 mx-auto mt-3">
                                    <button type="submit"  id="submitBtn" class="btn btn-primary w-100"><?php echo e(__('Save')); ?></button>
                                </div>
                            </form>
                        </div>
                    </div>
                </section>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <?php echo $__env->yieldPushContent('datatableScripts'); ?>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script>
        function saveMCQAnswers() {
            let answers = [];
            $('.answers-wrapper .answer-item').each(function (index) {
                let text = $(this).find('textarea').val() || '';
                answers.push(text);
            });
            let correctIndex = $('input.correct-radio:checked').val();
            return {answers, correctIndex};
        }

        function restoreMCQAnswers(data) {
            if (!data) return;
            $('.answers-wrapper .answer-item').each(function (index) {
                $(this).find('textarea').val(data.answers[index] || '');
            });
            if (data.correctIndex !== undefined) {
                $(`input.correct-radio[value="${data.correctIndex}"]`).prop('checked', true).trigger('change');
            }
        }

        $(document).ready(function () {
            $('.select2').select2({
                placeholder: "<?php echo e(__('Select')); ?>",
                allowClear: true,
                width: '100%'
            });

            $('#course-select').on('change', function () {
                let courseId = $(this).val();
                let $lessonSelect = $('#lesson-select');

                if (!courseId) {
                    $lessonSelect.html('<option value=""><?php echo e(__("Select Lesson")); ?></option>').trigger('change');
                    return;
                }

                let urlTemplate = '<?php echo e(route("teacher.lessons.byCourse", ["course" => ":course"])); ?>';
                let url = urlTemplate.replace(':course', courseId);

                $.ajax({
                    url: url,
                    type: 'GET',
                    dataType: 'json',
                    success: function (data) {
                        let lessons = data.lessons || data.data || [];
                        let options = '<option value=""><?php echo e(__("Select Lesson")); ?></option>';

                        if (typeof lessons === 'object' && Object.keys(lessons).length > 0) {
                            $.each(lessons, function (id, title) {
                                options += `<option value="${id}">${title}</option>`;
                            });
                        } else {
                            options += `<option disabled><?php echo e(__('No lessons found')); ?></option>`;
                        }

                        $lessonSelect.html(options).trigger('change');
                    },
                    error: function () {
                        alert("<?php echo e(__('Failed to load lessons')); ?>");
                    }
                });
            });
            const validationErrors = <?php echo json_encode($errors->messages(), 15, 512) ?>;


            function buildMCQAnswers() {
                let html = '';
                for (let i = 0; i < 5; i++) {
                    let textError = validationErrors[`answer_${i}_text`] ? validationErrors[`answer_${i}_text`][0] : '';
                    let imageError = validationErrors[`answer_${i}_image`] ? validationErrors[`answer_${i}_image`][0] : '';
                    let commentError = validationErrors[`comment_${i}_text`] ? validationErrors[`comment_${i}_text`][0] : '';

                    html += `
        <div class="answer-block" id="answer-block-${i}">

            <div class="answer-item main-answer">
                <div class="answer-text-wrapper">
                    <textarea name="answer_${i}_text" class="form-control" placeholder="<?php echo e(__('Answer')); ?> ${i + 1}"></textarea>
                    ${textError ? `<small class="text-danger">${textError}</small>` : ''}
                </div>
                <div class="answer-file-wrapper col-4">
                    <input type="file" name="answer_${i}_image" accept="image/*" class="form-control p-1" title="Upload image for answer">
                    ${imageError ? `<small class="text-danger">${imageError}</small>` : ''}
                </div>
                <div class="correct-wrapper" tabindex="0" role="radio" aria-checked="false" data-radio-id="correct_answer_${i}">
                    <input class="correct-radio" type="radio" name="correct_answer" id="correct_answer_${i}" value="${i}">
                    <svg class="correct-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
                        <path d="M20.285 6.709a1 1 0 0 0-1.414-1.418l-9.192 9.199-4.192-4.2a1 1 0 0 0-1.415 1.415l4.9 4.906a1 1 0 0 0 1.414 0l9.899-9.902z"/>
                    </svg>
                    <span><?php echo e(__('Correct')); ?></span>
                </div>
            </div>

            <div class="answer-item comment-part mt-2">
                <div class="comment-text-wrapper col-12">
                    <textarea name="comment_${i}_text" class="form-control" placeholder="<?php echo e(__('Comment')); ?> ${i + 1}"     style="padding: 10px;"
></textarea>
                    ${commentError ? `<small class="text-danger">${commentError}</small>` : ''}
                </div>
            </div>

        </div>`;
                }
                return `<div class="answers-group">${html}</div>`;
            }

            function buildEssayAnswer() {
                return `
<div class="answers-group">
    <div class="answer-item essay-item">
        <div class="answer-text-wrapper">
            <textarea
                name="answer_text"
                class="form-control"
                placeholder="<?php echo e(__('Write your answer here')); ?>"
                rows="6"></textarea>
            <?php $__errorArgs = ['answer_text'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                <small class="text-danger"><?php echo e($message); ?></small>
            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <div class="comment-row">
                    <textarea
                        name="comment_text"
                        class="form-control"
                        placeholder="<?php echo e(__('Add your comment')); ?>"></textarea>
            <?php $__errorArgs = ['comment_text'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                <small class="text-danger"><?php echo e($message); ?></small>
            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
            </div>
        </div>`;
            }



            function updateSelectedAnswerStyles() {
                $('.answer-block').removeClass('selected-answer');
                $('.correct-wrapper').removeClass('selected').attr('aria-checked', 'false');

                let checkedRadio = $('input.correct-radio:checked');
                if (checkedRadio.length) {
                    let $answerBlock = checkedRadio.closest('.answer-block');
                    $answerBlock.addClass('selected-answer');
                    $answerBlock.find('.correct-wrapper').addClass('selected').attr('aria-checked', 'true');
                }
            }


            $('#question_type').on('change', function () {
                const type = $(this).val();
                const $answersWrapper = $('.answers-wrapper');
                let savedMCQData = null;
                if ($answersWrapper.find('.answer-item').length > 0 && $answersWrapper.find('.answer-item').first().hasClass('essay-item') === false) {
                    savedMCQData = saveMCQAnswers();
                }


                if (type === 'Grid-in') {
                    $answersWrapper.html(buildEssayAnswer());
                } else {
                    $answersWrapper.html(buildMCQAnswers());
                    restoreMCQAnswers(savedMCQData);

                }

                updateSelectedAnswerStyles();

                $('.correct-wrapper').off('click').on('click', function () {
                    let radio = $(this).find('input.correct-radio');
                    radio.prop('checked', true).trigger('change');
                });

                $('.correct-wrapper').off('keydown').on('keydown', function (e) {
                    if (e.key === ' ' || e.key === 'Enter') {
                        e.preventDefault();
                        $(this).click();
                    }
                });

                $('input.correct-radio').off('change').on('change', function () {
                    updateSelectedAnswerStyles();
                });
            });

            $('#question_type').trigger('change');

            $(function () {
                const $form = $('form[action="<?php echo e(route('teacher.questions-bank.store')); ?>"]');
                const $questionType = $('#question_type');

                function showCorrectError(msg) {
                    let $err = $('#correct-answer-error');
                    if (!$err.length) {
                        $('.answers-wrapper').prepend('<div id="correct-answer-error" class="mt-2"></div>');
                        $err = $('#correct-answer-error');
                    }
                    $err
                        .html('<small class="text-danger"><i class="fas fa-exclamation-circle me-1"></i> ' + msg + '</small>')
                        .show();
                }

                function clearCorrectError() {
                    $('#correct-answer-error').remove();
                }

                function hasAnyAnswerContent() {
                    let ok = false;
                    $('.answers-wrapper .answer-item').each(function () {
                        const txt = $(this).find('textarea').val()?.trim();
                        const file = $(this).find('input[type="file"]')[0]?.files?.length > 0;
                        if (txt || file) {
                            ok = true;
                            return false;
                        }
                    });
                    return ok;
                }

                function toggleRequiredForRadios() {
                    const isMcq = $questionType.val() === 'mcq';
                    const $radios = $('input.correct-radio');
                    if (isMcq) {
                        $radios.attr('required', true);
                    } else {
                        $radios.removeAttr('required');
                        clearCorrectError();
                    }
                }


                toggleRequiredForRadios();
                $questionType.on('change', function () {

                    setTimeout(toggleRequiredForRadios, 0);
                });


                $(document).on('change', 'input.correct-radio', function () {
                    clearCorrectError();
                });

                $form.on('submit', function (e) {
                    if ($questionType.val() !== 'mcq') return;

                    const hasCorrect = $('input.correct-radio:checked').length > 0;
                    const hasContent = hasAnyAnswerContent();

                    if (!hasContent) {
                        e.preventDefault();
                        showCorrectError('<?php echo e(__("At least one answer must be provided for MCQ questions.")); ?>');

                        $('.answers-wrapper .answer-item textarea').first().focus();
                        return;
                    }

                    if (!hasCorrect) {
                        e.preventDefault();
                        showCorrectError('<?php echo e(__("Please choose the correct answer before submitting.")); ?>');

                        $('.answers-wrapper .correct-wrapper').first().focus();
                        return;
                    }
                });
                document.getElementById("myForm").addEventListener("submit", function () {
                    let btn = document.getElementById("submitBtn");
                    btn.disabled = true;
                    btn.innerText = "<?php echo e(__('Saving...')); ?>";
                });
            });
        });
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('components.dashboard.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/am2/public_html/resources/views/dashboard/questions-bank/create.blade.php ENDPATH**/ ?>