<?php $__env->startSection('title', __('Edit Lesson')); ?>

<?php $__env->startSection('content'); ?>
    <div class="app-content content">
        <div class="content-wrapper">
            <?php if (isset($component)) { $__componentOriginalddcd638d544798a22b5064bdbb7bdb0c = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalddcd638d544798a22b5064bdbb7bdb0c = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.dashboard.layouts.breadcrumb','data' => ['now' => ''.e(__('Edit Lesson')).'']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('dashboard.layouts.breadcrumb'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['now' => ''.e(__('Edit Lesson')).'']); ?>
                 <?php $__env->slot('name', null, []); ?> <?php echo e(__('Lessons List')); ?> <?php $__env->endSlot(); ?>
                 <?php $__env->slot('route', null, []); ?> <?php echo e(route('teacher.lessons.index')); ?> <?php $__env->endSlot(); ?>
             <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalddcd638d544798a22b5064bdbb7bdb0c)): ?>
<?php $attributes = $__attributesOriginalddcd638d544798a22b5064bdbb7bdb0c; ?>
<?php unset($__attributesOriginalddcd638d544798a22b5064bdbb7bdb0c); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalddcd638d544798a22b5064bdbb7bdb0c)): ?>
<?php $component = $__componentOriginalddcd638d544798a22b5064bdbb7bdb0c; ?>
<?php unset($__componentOriginalddcd638d544798a22b5064bdbb7bdb0c); ?>
<?php endif; ?>

            <form action="<?php echo e(route('teacher.lessons.update', $lesson->id)); ?>" method="POST" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                <div class="card">
                    <div class="card-body">

                        
                        <div class="form-group">
                            <label><?php echo e(__('Lesson Title')); ?></label>
                            <input type="text" name="title" class="form-control" value="<?php echo e(old('title', $lesson->title)); ?>" required>
                            <?php $__errorArgs = ['title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <small class="text-danger"><?php echo e($message); ?></small> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        
                        <div class="form-group">
                            <label><?php echo e(__('Description')); ?></label>
                            <textarea name="description" rows="3" class="form-control"><?php echo e(old('description', $lesson->description)); ?></textarea>
                            <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <small class="text-danger"><?php echo e($message); ?></small> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        
                        <div class="form-group">
                            <label><?php echo e(__('Select Course')); ?></label>
                            <select name="course_id" class="form-control">
                                <option value=""><?php echo e(__('Choose...')); ?></option>
                                <?php $__currentLoopData = $courses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($course->id); ?>" <?php echo e($lesson->course_id == $course->id ? 'selected' : ''); ?>>
                                        <?php echo e($course->title); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <?php $__errorArgs = ['course_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <small class="text-danger"><?php echo e($message); ?></small> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        
                        <div class="form-group">
                            <label><?php echo e(__('Status')); ?></label>
                            <select name="status" class="form-control">
                                <option value="1" <?php echo e($lesson->status == 1 ? 'selected' : ''); ?>><?php echo e(__('Active')); ?></option>
                                <option value="0" <?php echo e($lesson->status == 0 ? 'selected' : ''); ?>><?php echo e(__('Hidden')); ?></option>
                            </select>
                            <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <small class="text-danger"><?php echo e($message); ?></small> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        
                        <div class="form-group">
                            <label><?php echo e(__('External Video Links')); ?></label>
                            <div id="video-links-wrapper">
                                <?php $__empty_1 = true; $__currentLoopData = $lesson->videos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $video): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <div class="input-group mb-2">
                                        <input type="url" name="external_video_links[]" class="form-control" value="<?php echo e($video->link); ?>" placeholder="https://vimeo.com/...">
                                        <div class="input-group-append">
                                            <button type="button" class="btn btn-danger remove-link">×</button>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <div class="input-group mb-2">
                                        <input type="url" name="external_video_links[]" class="form-control" placeholder="https://vimeo.com/...">
                                        <div class="input-group-append">
                                            <button type="button" class="btn btn-danger remove-link">×</button>
                                        </div>
                                    </div>
                                <?php endif; ?>
                            </div>
                            <button type="button" class="btn btn-sm btn-primary mt-1" id="add-video-link"><?php echo e(__('Add Video Link')); ?></button>
                            <small class="form-text text-muted">
                                <?php echo e(__('Only Vimeo links are allowed (e.g. https://vimeo.com/123456789)')); ?>

                            </small>
                            <?php $__errorArgs = ['external_video_links.*'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <small class="text-danger d-block"><?php echo e($message); ?></small> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        
                        <?php if($lesson->getMedia('pdfs')->count()): ?>
                            <div class="form-group">
                                <label><?php echo e(__('Uploaded PDFs')); ?></label>
                                <ul id="uploaded-pdfs" class="list-group mb-2">
                                    <?php $__currentLoopData = $lesson->getMedia('pdfs'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $media): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li class="list-group-item d-flex justify-content-between align-items-center">
                                            <a href="<?php echo e($media->getFullUrl()); ?>" target="_blank"><?php echo e($media->file_name); ?></a>
                                            <button type="button" class="btn btn-sm btn-danger delete-pdf" data-url="<?php echo e(route('teacher.lessons.pdf.delete', [$lesson->id, $media->id])); ?>">
                                                <i class="fa fa-trash"></i>
                                            </button>
                                        </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        <?php endif; ?>

                        
                        <div class="form-group">
                            <label><?php echo e(__('Upload PDFs')); ?></label>
                            <div id="pdf-links-wrapper">
                                <div class="input-group mb-2">
                                    <input type="file" name="pdfs[]" class="form-control" accept="application/pdf">
                                    <div class="input-group-append">
                                        <button class="btn btn-danger remove-pdf" type="button">×</button>
                                    </div>
                                </div>
                            </div>
                            <button type="button" class="btn btn-sm btn-primary mt-1" id="add-pdf-upload"><?php echo e(__('Add PDF Upload')); ?></button>
                            <?php $__errorArgs = ['pdfs.*'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <small class="text-danger"><?php echo e($message); ?></small> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="form-group">
                            <label for="image"><?php echo e(__('Lesson Image')); ?></label>
                            <input type="file" name="image" class="form-control" accept="image/*">
                            <?php $__errorArgs = ['image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <small class="text-danger"><?php echo e($message); ?></small>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        
                        <?php if($lesson->image): ?>
                            <div class="form-group mt-2">
                                <label><?php echo e(__('Current Image')); ?></label><br>
                                <img src="<?php echo e($lesson->image); ?>" alt="Lesson Image" style="max-width: 200px;" class="img-thumbnail mt-2">
                            </div>
                        <?php endif; ?>

                        <button type="submit" class="btn btn-success"><?php echo e(__('Update Lesson')); ?></button>
                    </div>
                </div>
            </form>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const videoWrapper = document.getElementById('video-links-wrapper');
            const addVideoBtn = document.getElementById('add-video-link');
            const pdfWrapper = document.getElementById('pdf-links-wrapper');
            const addPdfBtn = document.getElementById('add-pdf-upload');

            // Add video
            addVideoBtn.addEventListener('click', function () {
                const div = document.createElement('div');
                div.className = 'input-group mb-2';
                div.innerHTML = `
            <input type="url" name="external_video_links[]" class="form-control" placeholder="https://youtube.com/...">
            <div class="input-group-append">
                <button class="btn btn-danger remove-link" type="button">×</button>
            </div>`;
                videoWrapper.appendChild(div);
            });

            // Add PDF
            addPdfBtn.addEventListener('click', function () {
                const div = document.createElement('div');
                div.className = 'input-group mb-2';
                div.innerHTML = `
            <input type="file" name="pdfs[]" class="form-control" accept="application/pdf">
            <div class="input-group-append">
                <button class="btn btn-danger remove-pdf" type="button">×</button>
            </div>`;
                pdfWrapper.appendChild(div);
            });

            // Remove elements
            document.addEventListener('click', function (e) {
                if (e.target.classList.contains('remove-link')) {
                    const links = document.querySelectorAll('input[name="external_video_links[]"]');
                    if (links.length <= 1) {
                        Swal.fire({
                            icon: 'warning',
                            title: '<?php echo e(__("Warning!")); ?>',
                            text: '<?php echo e(__("You must have at least one video link.")); ?>'
                        });
                        return;
                    }
                    e.target.closest('.input-group').remove();
                }

                if (e.target.classList.contains('remove-pdf')) {
                    const pdfs = document.querySelectorAll('input[name="pdfs[]"]');
                    if (pdfs.length <= 1) {
                        Swal.fire({
                            icon: 'warning',
                            title: '<?php echo e(__("Warning!")); ?>',
                            text: '<?php echo e(__("You must have at least one PDF file.")); ?>'
                        });
                        return;
                    }
                    e.target.closest('.input-group').remove();
                }

                if (e.target.closest('.delete-pdf')) {
                    const btn = e.target.closest('.delete-pdf');
                    const url = btn.getAttribute('data-url');
                    Swal.fire({
                        title: '<?php echo e(__("Are you sure?")); ?>',
                        text: '<?php echo e(__("This PDF will be deleted.")); ?>',
                        icon: 'warning',
                        showCancelButton: true,
                        confirmButtonText: '<?php echo e(__("Yes, delete it!")); ?>',
                        cancelButtonText: '<?php echo e(__("Cancel")); ?>'
                    }).then((result) => {
                        if (result.isConfirmed) {
                            fetch(url, {
                                method: 'DELETE',
                                headers: {
                                    'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                                    'Accept': 'application/json',
                                },
                            })
                                .then(res => res.json() )
                                .then(data => {
                                    location.reload();
                                    if (data.success) {
                                        btn.closest('li').remove();
                                        Swal.fire('<?php echo e(__("Deleted!")); ?>', data.message, 'success');
                                    } else {
                                        Swal.fire('<?php echo e(__("Error!")); ?>', data.message, 'error');
                                    }
                                });
                        }
                    });
                }
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('components.dashboard.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/am2/public_html/resources/views/dashboard/lessons/edit.blade.php ENDPATH**/ ?>