
<?php $__env->startSection('script'); ?>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

    <script>
        $(document).ready(function () {
            const existingQuestions = <?php echo json_encode($quiz->questions->pluck('id'), 15, 512) ?>;
            const $select = $('#questions-select2');
            const $questionTable = $('#question-table');
            const token = '<?php echo e(csrf_token()); ?>';
            const lessonId = $('#lesson_id').val();

            $select.select2({
                placeholder: '<?php echo e(__("Search...")); ?>',
                minimumInputLength: 2,
                ajax: {
                    url: `/teacher/lesson/create-quiz-ajax/${lessonId}`,
                    dataType: 'json',
                    delay: 250,
                    data: function (params) {
                        return { keyword: params.term };
                    },
                    processResults: function (data) {
                        return {
                            results: data.map(item => ({
                                id: item.id,
                                text: item.question_text
                            }))
                        };
                    }
                }
            });

            function renderQuestionTable(questions) {
                $questionTable.empty();
                if (!questions.length) {
                    $questionTable.append(`
                        <tr><td class="px-4 py-3 text-center text-gray-500">
                            <?php echo e(__('Select questions from the list above')); ?>

                    </td></tr>`);
                    return;
                }

                questions.forEach(q => {
                    let optionsHtml = '';
                    if (q.question_type === 'mcq') {
                        optionsHtml += `<div class="grid grid-cols-1 sm:grid-cols-2 gap-3 mt-2">`;
                        q.options.forEach(opt => {
                            optionsHtml += `
                                <div class="relative p-3 rounded-md border ${opt.is_correct ? 'bg-green-100 border-green-400 text-green-900 font-semibold' : 'bg-gray-50'}">
                                    ${opt.is_correct ? `<span class="absolute top-2 right-2 bg-green-600 text-white text-xs px-2 py-0.5 rounded shadow"><?php echo e(__('Correct Answer')); ?></span>` : ''}
                                    <div class="flex items-center gap-2">
                                        <i class="fa fa-circle ${opt.is_correct ? 'text-green-600' : 'text-gray-400'}"></i>
                                        ${opt.answer}
                                    </div>
                                    ${opt.image ? `<img src="${opt.image}" class="mt-2 w-20 h-20 rounded-full border object-cover mx-auto">` : ''}
                                </div>`;
                        });
                        optionsHtml += `</div>`;
                    }

                    let row = `
                        <tr>
                            <td style="display:none;">
                                <input type="checkbox" name="questions[]" value="${q.id}" checked>
                            </td>
                            <td class="align-top px-4 py-3">
                                <div class="flex justify-between gap-6 items-center">
                                    <div>
                                        <p class="font-semibold mb-2" style="max-width:200px;">${q.question_text}</p>
                                        ${q.image ? `<img src="${q.image}" class="w-[150px] h-[120px] rounded shadow object-contain">` : ''}
                                    </div>
                                    <div class="flex-1">${optionsHtml}</div>
                                    <div class="text-sm flex flex-col gap-2">
                                        <div class="px-3 py-1 rounded-xl bg-green-100 text-green-800 font-semibold">${q.question_type.toUpperCase()}</div>
                                        <div class="px-3 py-1 rounded-xl bg-blue-100 text-blue-800"><?php echo e(__('Difficulty:')); ?> ${q.difficulty_level}</div>
                                        <div class="px-3 py-1 rounded-xl bg-yellow-100 text-yellow-800"><?php echo e(__('Score:')); ?> ${q.score}</div>
                                        ${q.question_type !== 'mcq' && q.answer ? `<div class="px-3 py-1 rounded-xl bg-purple-100 text-purple-800"><?php echo e(__('Expected:')); ?> ${q.answer}</div>` : ''}
                                    </div>
                                </div>
                            </td>
                        </tr>`;
                    $questionTable.append(row);
                });
            }

            if (existingQuestions.length) {
                $.ajax({
                    url: '/teacher/questions/details',
                    type: 'GET',
                    data: { ids: existingQuestions, _token: token },
                    success: function (questions) {
                        questions.forEach(q => {
                            const option = new Option(q.question_text, q.id, true, true);
                            $select.append(option);
                        });
                        $select.trigger('change');
                        renderQuestionTable(questions);
                    }
                });
            }

            $select.on('change', function () {
                const selectedIds = $(this).val();
                if (!selectedIds.length) return renderQuestionTable([]);

                $.ajax({
                    url: '/teacher/questions/details',
                    type: 'GET',
                    data: { ids: selectedIds, _token: token },
                    success: function (questions) {
                        renderQuestionTable(questions);
                    }
                });
            });
        });
    </script>
<?php $__env->stopSection(); ?>
<?php /**PATH /home/am2/public_html/resources/views/dashboard/lessons/edit-scripts.blade.php ENDPATH**/ ?>