<?php $__env->startSection('title', __('Reassign Exam')); ?>

<?php $__env->startSection('styles'); ?>
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <style>
        .select2-container--default .select2-selection--multiple {
            min-height: 44px;
            padding: 6px;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="app-content content">
        <div class="content-overlay"></div>
        <div class="header-navbar-shadow"></div>
        <div class="content-wrapper">
            <div class="content-header row"></div>
            <div class="content-body">
                <?php if (isset($component)) { $__componentOriginalddcd638d544798a22b5064bdbb7bdb0c = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalddcd638d544798a22b5064bdbb7bdb0c = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.dashboard.layouts.breadcrumb','data' => ['now' => ''.e(__('Reassign Exam')).'']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('dashboard.layouts.breadcrumb'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['now' => ''.e(__('Reassign Exam')).'']); ?>
                    <li class="breadcrumb-item"><a href="<?php echo e(route('teacher.exams.index')); ?>"><?php echo e(__('Exams List')); ?></a></li>
                 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalddcd638d544798a22b5064bdbb7bdb0c)): ?>
<?php $attributes = $__attributesOriginalddcd638d544798a22b5064bdbb7bdb0c; ?>
<?php unset($__attributesOriginalddcd638d544798a22b5064bdbb7bdb0c); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalddcd638d544798a22b5064bdbb7bdb0c)): ?>
<?php $component = $__componentOriginalddcd638d544798a22b5064bdbb7bdb0c; ?>
<?php unset($__componentOriginalddcd638d544798a22b5064bdbb7bdb0c); ?>
<?php endif; ?>

                <div class="row mt-2">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header">
                                <h4 class="card-title"><?php echo e(__('Reassign Exam')); ?> - <?php echo e($exam->title); ?></h4>
                            </div>
                            <div class="card-body">
                                <form action="<?php echo e(route('teacher.exams.reassign', $exam->id)); ?>" method="POST">
                                    <?php echo csrf_field(); ?>
                                    <div class="mb-3">
                                        <label for="start_time"><?php echo e(__('Start Time')); ?></label>
                                        <input type="datetime-local" class="form-control" id="start_time" name="start_time" required>
                                    </div>

                                    <!-- End Time -->
                                    <div class="mb-3">
                                        <label for="end_time"><?php echo e(__('End Time')); ?></label>
                                        <input type="datetime-local" class="form-control" id="end_time" name="end_time" required>
                                    </div>
                                    <!-- Group multi-select -->
                                    <div class="mb-3">
                                        <label for="group-select"><?php echo e(__('Select Groups')); ?></label>
                                        <select id="group-select" class="form-control" name="group_ids[]" multiple>
                                            <?php $__currentLoopData = $groups; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $group): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($group->id); ?>"><?php echo e($group->title); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>

                                    <input type="hidden" name="toggle" value="0">
                                    <div class="form-check mb-3">
                                        <input class="form-check-input" name="toggle" type="checkbox" id="toggle-students" value="1">
                                        <label class="form-check-label" for="toggle-students">
                                            <?php echo e(__('Reassign only to specific students')); ?>

                                        </label>
                                    </div>



                                    <!-- Student select -->
                                    <div id="student-select-wrapper" class="mb-3 d-none">
                                        <label for="student-select"><?php echo e(__('Select Students')); ?></label>
                                        <select id="student-select" class="form-control" name="student_ids[]" multiple></select>
                                    </div>

                                    <div class="mt-4">
                                        <button type="submit" class="btn btn-primary"><?php echo e(__('Reassign Exam')); ?></button>
                                        <a href="<?php echo e(route('teacher.exams.index')); ?>" class="btn btn-secondary"><?php echo e(__('Cancel')); ?></a>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div> <!-- end row -->
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

    <script>
        // Prepare students grouped by group ID
        const allStudentsByGroup = <?php echo json_encode(
            $groups->mapWithKeys(fn($group) => [
                $group->id => $group->studentProfiles->map(fn($student) => [
                    'id' => $student->user_id, 'name' => $student->user->name, 'group' => $group->title
                ])
            ])) ?>;

        $(document).ready(function () {
            const groupSelect = $('#group-select');
            const studentSelect = $('#student-select');
            const studentWrapper = $('#student-select-wrapper');
            const toggleStudents = $('#toggle-students');

            // Initialize Select2
            groupSelect.select2({
                placeholder: "<?php echo e(__('Select Groups')); ?>",
                width: '100%'
            });

            studentSelect.select2({
                placeholder: "<?php echo e(__('Select Students')); ?>",
                width: '100%'
            });

            // Show/hide student dropdown
            toggleStudents.on('change', function () {
                if ($(this).is(':checked')) {
                    studentWrapper.removeClass('d-none');
                    updateStudents();
                } else {
                    studentWrapper.addClass('d-none');
                }
            });

            // Update students on group change
            groupSelect.on('change', function () {
                if (toggleStudents.is(':checked')) {
                    updateStudents();
                }
            });

            function updateStudents() {
                const selectedGroupIds = groupSelect.val() || [];
                const uniqueStudents = {};

                selectedGroupIds.forEach(groupId => {
                    const students = allStudentsByGroup[groupId] || [];
                    students.forEach(student => {
                        uniqueStudents[student.id] = `${student.name} (${student.group})`;
                    });
                });

                // Clear and repopulate student select
                studentSelect.empty();
                for (const [id, name] of Object.entries(uniqueStudents)) {
                    studentSelect.append(new Option(name, id));
                }
                studentSelect.trigger('change.select2');
            }
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('components.dashboard.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/am2/public_html/resources/views/dashboard/exams/re-assign.blade.php ENDPATH**/ ?>