<?php $__env->startSection('script'); ?>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script>
        $(document).ready(function () {
            const $creationType = $('#creation-type-select');
            const $numberInput = $('#number-of-questions');
            const $checkboxes = $('input[type="checkbox"][name^="questions"]');
            const $questionsGroup = $('#questions-group');
            const questionSearch = $('#questions-search');
            function toggleQuestionSection() {
                const type = $creationType.val();
                if (type === 'manual') {
                    $questionsGroup.show();
                    questionSearch.show();
                } else {
                    $questionsGroup.hide();
                    questionSearch.hide();
                }
            }
            toggleQuestionSection();
            $creationType.on('change', function () {
                toggleQuestionSection();
                $checkboxes.prop('checked', false);
            });

            $checkboxes.on('change', function () {
                if ($creationType.val() !== 'manual') return;

                const max = parseInt($numberInput.val());
                const checked = $checkboxes.filter(':checked').length;

                if (!isNaN(max) && checked > max) {
                    this.checked = false;
                    Swal.fire({
                        icon: 'warning',
                        title: '<?php echo e(__("Oops!")); ?>',
                        text: '<?php echo e(__("You can only select up to")); ?> ' + max + ' <?php echo e(__("questions.")); ?>',
                        confirmButtonColor: '#3085d6',
                        confirmButtonText: '<?php echo e(__("OK")); ?>'
                    });
                }
            });

            let search = '<?php echo e(__('Search for questions...')); ?>';
            $('#questions-select2').select2({
                placeholder: search,
                dir: '<?php echo e(app()->getLocale() === 'ar' ? 'rtl' : 'ltr'); ?>',
                minimumInputLength: 0,
                ajax: {
                    url: `/teacher/lesson/create-quiz-ajax/${$('#lesson_id').val()}`,
                    dataType: 'json',
                    delay: 250,
                    data: function (params) {
                        return {
                            keyword: params.term
                        };
                    },
                    processResults: function (data) {
                        return {
                            results: $.map(data, function (item) {
                                return {
                                    id: item.id,
                                    text: item.question_text
                                };
                            })
                        };
                    },
                    cache: true
                }
            });

            $('#questions-select2').on('change', function (e) {
                const selectedIds = $(this).val() || [];
                let DifficultyTranslation = '<?php echo e(__('Difficulty:')); ?>';
                let ScoreTranslation = '<?php echo e(__('Score:')); ?>';
                let ExpectedTranslation = '<?php echo e(__('Expected:')); ?>';
                let CorrectAnswerTranslation = '<?php echo e(__('Correct Answer')); ?>';



                const max = parseInt($('#number-of-questions').val());
                if (!isNaN(max) && selectedIds.length >= max) {
                    $('#questions-select2').on('select2:opening', function (e) {
                        e.preventDefault();
                    });
                } else {
                    $('#questions-select2').off('select2:opening');
                }

                $('#question-table').empty();

                if (selectedIds.length > 0) {
                    $.ajax({
                        url: '/teacher/questions/details',
                        type: 'GET',
                        data: {
                            ids: selectedIds,
                            _token: '<?php echo e(csrf_token()); ?>'
                        },
                        success: function (questions) {
                            questions.forEach(q => {
                                let optionsHtml = '';

                                if (q.question_type === 'mcq') {
                                    optionsHtml += `<div class="grid grid-cols-1 sm:grid-cols-2 gap-3 mt-2">`;
                                    q.options.forEach(opt => {
                                        optionsHtml += `
                                <div class="relative p-3 rounded-md border ${opt.is_correct ? 'bg-green-100 border-green-400 text-green-900 font-semibold' : 'bg-gray-50'}">
                                    ${opt.is_correct ? `<span class="absolute top-2 right-2 bg-green-600 text-white text-xs px-2 py-0.5 rounded shadow">${CorrectAnswerTranslation}</span>` : ''}
                                    <div class="flex items-center gap-2">
                                        <i class="fa fa-circle ${opt.is_correct ? 'text-green-600' : 'text-gray-400'}"></i>
                                        ${opt.answer}
                                    </div>
                                    ${opt.image ? `<img src="${opt.image}" class="mt-2 w-20 h-20 rounded-full border object-cover mx-auto">` : ''}
                                </div>`;
                                    });
                                    optionsHtml += `</div>`;
                                }

                                let questionRow = `
                        <tr class="question-row">
                            <td style="display:none;">
                                <input type="checkbox" name="questions[]" value="${q.id}" checked>
                            </td>
                            <td class="align-top px-4 py-3">
                                <div class="flex justify-between gap-6 items-center">
                                    <div>
                                        <p class="font-semibold mb-2" style="max-width:200px;">${q.question_text}</p>
                                        ${q.image ? `<img src="${q.image}" class="w-[150px] h-[120px] rounded shadow object-contain">` : ''}
                                    </div>
                                    <div class="flex-1">
                                        ${optionsHtml}
                                    </div>
                                    <div class="text-sm flex flex-col gap-2">
                                        <div class="px-3 py-1 rounded-xl bg-green-100 text-green-800 font-semibold">${q.question_type.toUpperCase()}</div>
                                        <div class="px-3 py-1 rounded-xl bg-blue-100 text-blue-800">${DifficultyTranslation} ${q.difficulty_level.charAt(0).toUpperCase() + q.difficulty_level.slice(1)}</div>
                                        <div class="px-3 py-1 rounded-xl bg-yellow-100 text-yellow-800">${ScoreTranslation} ${q.score}</div>
                                        ${q.question_type !== 'mcq' && q.answer ? `<div class="px-3 py-1 rounded-xl bg-purple-100 text-purple-800">${ExpectedTranslation} ${q.answer}</div>` : ''}
                                    </div>
                                </div>
                            </td>
                        </tr>`;

                                $('#question-table').append(questionRow);
                            });
                        }
                    });
                } else {
                    $('#question-table').append(`
                        <tr>
                            <td class="px-4 py-3">
                                <div class="text-center text-gray-500">
                                    <?php echo e(__('Select questions from the list above')); ?>

                    </div>
                </td>
            </tr>
`);
                }
            });
        });

    </script>
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const creationType = document.getElementById('creation-type-select');
            const autoDiv = document.getElementById('auto-question-distribution');
            const numberOfQuestions = document.getElementById('number-of-questions');
            const easy = document.getElementById('easy-questions');
            const medium = document.getElementById('medium-questions');
            const hard = document.getElementById('hard-questions');
            const errorText = document.getElementById('questions-sum-error');
            const form = document.getElementById('quiz-form');

            function toggleAutoFields() {
                if (creationType.value === 'auto') {
                    autoDiv.style.display = 'flex';
                } else {
                    autoDiv.style.display = 'none';
                    errorText.classList.add('d-none');
                }
            }

            function validateSum() {
                const total = parseInt(numberOfQuestions.value || 0);
                const sum = parseInt(easy.value || 0) + parseInt(medium.value || 0) + parseInt(hard.value || 0);
                if (creationType.value === 'auto' && total !== sum) {
                    errorText.classList.remove('d-none');
                    return false;
                }
                errorText.classList.add('d-none');
                return true;
            }

            creationType.addEventListener('change', toggleAutoFields);
            [easy, medium, hard, numberOfQuestions].forEach(input => input.addEventListener('input', validateSum));
            form.addEventListener('submit', function (e) {
                if (!validateSum()) {
                    e.preventDefault();
                }
            });

            toggleAutoFields();
        });
    </script>
<?php $__env->stopSection(); ?>
<?php /**PATH /home/am2/public_html/resources/views/dashboard/lessons/create-scripts.blade.php ENDPATH**/ ?>