
<div class="modal fade"
     id="addPaymentModal"
     tabindex="-1"
     role="dialog"
     aria-labelledby="addPaymentLabel">
    <div class="modal-dialog" role="document">
        <form id="addPaymentForm" method="POST" action="<?php echo e(route('teacher.students.addPayment')); ?>">
            <?php echo csrf_field(); ?>
            <input type="hidden" name="student_id" id="studentIdInput">
            <input type="hidden" name="course_id" id="courseIdInput">
            <input type="hidden" name="course_student_id" id="courseStudentId">


            <div class="modal-content border-primary">
                <div class="modal-header bg-primary text-white">
                    <h5 class="modal-title" id="addPaymentLabel"><?php echo e(__('Add Payment')); ?></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="<?php echo e(__('Close')); ?>">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>

                <div class="modal-body">
                    <div class="form-group" id="amount-payment">
                        <label for="paymentAmount"><?php echo e(__('Amount')); ?></label>
                        <input id="paymentAmount" type="number" step="0.01" name="amount" class="form-control" required>
                    </div>

                    <div class="form-group" id="data-payment">
                        <label for="paymentDate"><?php echo e(__('Payment Date')); ?></label>
                        <input id="paymentDate" type="date" name="date" class="form-control" required>
                    </div>

                    <div class="form-group" id="note-payment">
                        <label for="paymentNotes"><?php echo e(__('Notes')); ?></label>
                        <textarea id="paymentNotes" name="notes" class="form-control" rows="2"></textarea>
                    </div>

                    <div class="form-group" id="installment-payment">
                        <label for="installmentsSelect"><?php echo e(__('Select Installment (optional)')); ?></label>
                        <select name="installment_id" id="installmentsSelect" class="form-control">
                            <option value=""><?php echo e(__('No Installment')); ?></option>
                        </select>
                        <small class="text-muted d-block mt-1" id="installmentHelp"></small>
                    </div>

                </div>
                <div class="banner" id="banner" style="display: none;">

                    <h2 class="banner" style="display: flex;justify-content: center;"><?php echo e(__("There is no installments")); ?></h2>
                </div>
                <div class="modal-footer" id="save">
                    <button type="submit" class="btn btn-success"><?php echo e(__('Save Payment')); ?></button>
                </div>
            </div>
        </form>
    </div>
</div>
<script>
    $(document).ready(function () {
        // Handle the button click to open the modal
        $('[data-toggle="modal"]').on('click', function () {
            const studentId = $(this).data('student-id');
            const courseId = $(this).data('course-id');
            const courseStudentId = $(this).data('course-student-id');
            const installmentsUrl = $(this).data('get-installments-url');
            console.log(studentId, courseId, installmentsUrl);
            // Set the hidden inputs
            $('#studentIdInput').val(studentId);
            $('#courseIdInput').val(courseId);
            $('#courseStudentId').val(courseStudentId)

            // Clear previous installments
            $('#installmentsSelect').empty().append('<option value=""><?php echo e(__('No Installment')); ?></option>');

            // Fetch installments for the selected course
            $.ajax({
                url: installmentsUrl,
                type: 'GET',
                data: {course_id: courseId, student_id: studentId, course_student_id: courseStudentId},
                success: function (data) {
                    // clear select
                    if (!data || !data.installment) {
                        // hidden all input in form display none
                       $('#installment-payment').hide();
                        $('#amount-payment').hide();
                        $('#data-payment').hide();
                        $('#note-payment').hide();
                        $('#save').hide();
                        $('#banner').show();
                        $('#banner').style.display = 'flex';
                        $('#banner').style.justifyContent = 'center';


                        $('#installmentHelp').text('<?php echo e(__("No installments available for this course")); ?>');
                        return;
                    } else {
                        console.log(data.installment);
                        let select = $('#installmentsSelect');
                        select.empty();
                        select.append(
                            `<option value="${data.installment.id}">${data.installment.name}</option>`
                        );

                        $('#paymentAmount').val(data.installment.amount);
                        console.log(data.installment.amount);
                        $('#paymentAmount').attr('min', data.installment.minimum_amount);
                        $('#paymentAmount').attr('max', data.installment.amount);
                        console.log(data.installment.minimum_amount);

                        $('#installmentHelp').text('<?php echo e(__('Select an installment if applicable')); ?>');
                    }
                },
                error: function () {
                    console.log("error");
                    $('#installmentHelp').text('<?php echo e(__('Error fetching installments')); ?>');
                }
            });
        });
    });
</script>


<a href="#"
   class="btn btn-sm btn-primary text-white"
   data-toggle="modal"
   data-target="#addPaymentModal"
   data-student-id="<?php echo e($studentId); ?>"
   data-course-id="<?php echo e($courseId); ?>"
   data-course-student-id="<?php echo e($courseStudentId); ?>"
   data-get-installments-url="<?php echo e(route('teacher.students.getInstallments')); ?>">
    <i class="fa fa-plus"></i> <?php echo e(__('Add Payment')); ?>

</a>
<?php /**PATH /home/am2/public_html/resources/views/components/datatable/includes/columns/payment-actions.blade.php ENDPATH**/ ?>