<?php $__env->startSection('title', __('Add Lesson')); ?>

<?php $__env->startSection('content'); ?>
    <div class="app-content content">
        <div class="content-wrapper">
            <?php if (isset($component)) { $__componentOriginalddcd638d544798a22b5064bdbb7bdb0c = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalddcd638d544798a22b5064bdbb7bdb0c = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.dashboard.layouts.breadcrumb','data' => ['now' => ''.e(__('Add Lesson')).'']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('dashboard.layouts.breadcrumb'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['now' => ''.e(__('Add Lesson')).'']); ?>
                 <?php $__env->slot('name', null, []); ?> <?php echo e(__('Lessons List')); ?> <?php $__env->endSlot(); ?>
                 <?php $__env->slot('route', null, []); ?> <?php echo e(route('teacher.lessons.index')); ?> <?php $__env->endSlot(); ?>

             <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalddcd638d544798a22b5064bdbb7bdb0c)): ?>
<?php $attributes = $__attributesOriginalddcd638d544798a22b5064bdbb7bdb0c; ?>
<?php unset($__attributesOriginalddcd638d544798a22b5064bdbb7bdb0c); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalddcd638d544798a22b5064bdbb7bdb0c)): ?>
<?php $component = $__componentOriginalddcd638d544798a22b5064bdbb7bdb0c; ?>
<?php unset($__componentOriginalddcd638d544798a22b5064bdbb7bdb0c); ?>
<?php endif; ?>

            <form id="lessonForm" action="<?php echo e(route('teacher.lessons.store')); ?>" method="POST" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <div class="card">
                    <div class="card-body">

                        
                        <div class="form-group">
                            <label for="title"><?php echo e(__('Lesson Title')); ?></label>
                            <input type="text" class="form-control" name="title" value="<?php echo e(old('title')); ?>" required>
                            <?php $__errorArgs = ['title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <small class="text-danger"><?php echo e($message); ?></small>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        
                        <div class="form-group">
                            <label for="description"><?php echo e(__('Description')); ?></label>
                            <textarea class="form-control" name="description" rows="3"><?php echo e(old('description')); ?></textarea>
                            <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <small class="text-danger"><?php echo e($message); ?></small>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        
                        <div class="form-group">
                            <label for="course_id"><?php echo e(__('Select Course')); ?></label>
                            <select name="course_id" class="form-control">
                                <option value=""><?php echo e(__('Choose...')); ?></option>
                                <?php $__currentLoopData = $courses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($course->id); ?>" <?php echo e(old('course_id') == $course->id ? 'selected' : ''); ?>>
                                        <?php echo e($course->title); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <?php $__errorArgs = ['course_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <small class="text-danger"><?php echo e($message); ?></small>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        
                        <div class="form-group">
                            <label for="status"><?php echo e(__('Status')); ?></label>
                            <select name="status" class="form-control">
                                <option value="1" <?php echo e(old('status') == '1' ? 'selected' : ''); ?>><?php echo e(__('Active')); ?></option>
                                <option value="0" <?php echo e(old('status') == '0' ? 'selected' : ''); ?>><?php echo e(__('Hidden')); ?></option>
                            </select>
                            <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <small class="text-danger"><?php echo e($message); ?></small>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        
                        <div class="form-group">
                            <label><?php echo e(__('External Video Links')); ?></label>
                            <div id="video-links-wrapper">
                                <div class="input-group mb-2">
                                    <input type="url" name="external_video_links[]" class="form-control" placeholder="https://vimeo.com/...">
                                    <div class="input-group-append">
                                        <button class="btn btn-danger remove-link" type="button">×</button>
                                    </div>
                                </div>
                            </div>
                            <button type="button" class="btn btn-sm btn-primary mt-1" id="add-video-link"><?php echo e(__('Add Video Link')); ?></button>
                            <small class="form-text text-muted">
                                <?php echo e(__('Only Vimeo links are allowed (e.g. https://vimeo.com/123456789)')); ?>

                            </small>
                            <?php $__errorArgs = ['external_video_links.*'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <small class="text-danger d-block"><?php echo e($message); ?></small>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        
                        <div class="form-group">
                            <label><?php echo e(__('Upload PDFs')); ?></label>
                            <div id="pdf-links-wrapper">
                                <div class="input-group mb-2">
                                    <input type="file" name="pdfs[]" class="form-control" accept="application/pdf">
                                    <div class="input-group-append">
                                        <button class="btn btn-danger remove-pdf" type="button">×</button>
                                    </div>
                                </div>
                            </div>
                            <button type="button" class="btn btn-sm btn-primary mt-1" id="add-pdf-upload"><?php echo e(__('Add PDF Upload')); ?></button>
                            <?php $__errorArgs = ['pdfs.*'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <small class="text-danger"><?php echo e($message); ?></small>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="form-group">
                            <label for="image"><?php echo e(__('Lesson Image')); ?></label>
                            <input type="file" name="image" class="form-control" accept="image/*">
                            <?php $__errorArgs = ['image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <small class="text-danger"><?php echo e($message); ?></small>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <button id="submitLessonForm" type="submit" class="btn btn-success"><?php echo e(__('Create Lesson')); ?></button>
                    </div>
                </div>
            </form>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            // Video link logic
            const videoWrapper = document.getElementById('video-links-wrapper');
            const addVideoBtn = document.getElementById('add-video-link');

            addVideoBtn.addEventListener('click', function () {
                const div = document.createElement('div');
                div.className = 'input-group mb-2';
                div.innerHTML = `
                    <input type="url" name="external_video_links[]" class="form-control" placeholder="https://vimeo.com/...">
                    <div class="input-group-append">
                        <button class="btn btn-danger remove-link" type="button">×</button>
                    </div>`;
                videoWrapper.appendChild(div);
            });

            // PDF upload logic
            const pdfWrapper = document.getElementById('pdf-links-wrapper');
            const addPdfBtn = document.getElementById('add-pdf-upload');

            addPdfBtn.addEventListener('click', function () {
                const div = document.createElement('div');
                div.className = 'input-group mb-2';
                div.innerHTML = `
                    <input type="file" name="pdfs[]" class="form-control" accept="application/pdf">
                    <div class="input-group-append">
                        <button class="btn btn-danger remove-pdf" type="button">×</button>
                    </div>`;
                pdfWrapper.appendChild(div);
            });
            document.getElementById('lessonForm').addEventListener('submit', function (e) {
                let btn = document.getElementById('submitLessonForm');
                btn.disabled = true;
                btn.innerHTML = '<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>';
            });

            // Global remove handler
            document.addEventListener('click', function (e) {
                // Remove video link
                if (e.target && e.target.classList.contains('remove-link')) {
                    const links = document.querySelectorAll('input[name="external_video_links[]"]');
                    if (links.length <= 1) {
                        Swal.fire({
                            icon: 'warning',
                            title: '<?php echo e(__("Warning!")); ?>',
                            text: '<?php echo e(__("You must have at least one video link.")); ?>',
                            confirmButtonText: '<?php echo e(__("OK")); ?>'
                        });
                        return;
                    }
                    e.target.closest('.input-group').remove();
                }

                // Remove PDF input
                if (e.target && e.target.classList.contains('remove-pdf')) {
                    const pdfInputs = document.querySelectorAll('input[name="pdfs[]"]');
                    if (pdfInputs.length <= 1) {
                        Swal.fire({
                            icon: 'warning',
                            title: '<?php echo e(__("Warning!")); ?>',
                            text: '<?php echo e(__("You must have at least one PDF file.")); ?>',
                            confirmButtonText: '<?php echo e(__("OK")); ?>'
                        });
                        return;
                    }
                    e.target.closest('.input-group').remove();
                }
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('components.dashboard.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/am2/public_html/resources/views/dashboard/lessons/create.blade.php ENDPATH**/ ?>