<?php $__env->startSection('title', __('Submission Details')); ?>

<?php $__env->startSection('styles'); ?>
    <style>
        .question-title{font-size:1.5rem;font-weight:bold;letter-spacing:.5px;color:white;margin:0}
        .pointer{cursor:pointer}

        /* chips / badges */
        .badge-pill{border-radius:999px;padding:.35rem .6rem}
        .badge-chip{display:inline-flex;align-items:center;height:24px;padding:0 .5rem;border-radius:999px;font-size:.75rem}
        .badge-blue{background:#e9f1ff;color:#0b57d0}
        .badge-green{background:#e9fbea;color:#1e7e34}
        .badge-red{background:#ffe9ea;color:#d92d20}
        .badge-gray{background:#f1f5f9;color:#475569}

        /* meta grid */
        .q-meta{display:grid;grid-template-columns:repeat(3,minmax(0,1fr));gap:.75rem;margin:.5rem 0 1rem}
        .q-meta .item{background:#f7f8fa;border:1px solid #e7eaf0;border-radius:10px;padding:.5rem .75rem;font-size:.875rem}
        .q-meta .label{color:#6b7280;display:block;margin-bottom:.25rem;font-weight:600}
        .q-meta .value{display:inline-flex;align-items:center;gap:.35rem;font-weight:600}
        @media (max-width:992px){.q-meta{grid-template-columns:1fr 1fr}}
        @media (max-width:576px){.q-meta{grid-template-columns:1fr}}

        /* choices */
        .choices{border:1px solid #d6e0ef;border-radius:12px;overflow:hidden}
        .choice{display:flex;align-items:center;gap:.75rem;padding:.65rem .9rem;border-top:1px solid #eef2f7;background:#fff;transition:background .15s,box-shadow .15s}
        .choice:first-child{border-top:none}
        .choice:hover{background:#fafcff}
        .choice .num{width:2rem;height:2rem;border-radius:8px;display:flex;align-items:center;justify-content:center;font-weight:700;background:#f3f6fb;color:#3b82f6}
        .choice .text{flex:1;font-size:.95rem}
        .choice .marks{display:flex;gap:.4rem;align-items:center}
        .choice.is-picked{outline:2px solid #b6cffd;background:#f7fbff}
        .choice.is-correct{background:#e9fbea}
        .choice.is-correct .num{background:#d8f5dc;color:#198754}
        .choice.is-correct.is-picked{outline:2px solid #7bdc95;background:#dff8e4}

        /* images */
        .q-img,.opt-img{border-radius:10px;border:1px solid #e5e7eb}
        .q-img{max-width:300px;margin:.35rem 0 .6rem}
        .opt-img{max-width:150px;margin-top:.4rem}

        /* modal */
        #imageModal{display:none;position:fixed;z-index:10000;left:0;top:0;width:100%;height:100%;
            background:rgba(0,0,0,.8);justify-content:center;align-items:center}
        #imageModal img{max-width:90%;max-height:90%;border-radius:8px;box-shadow:0 0 20px rgba(0,0,0,.7)}
        #imageModal .closeBtn{position:absolute;top:20px;right:30px;font-size:40px;color:#fff;cursor:pointer;font-weight:bold;user-select:none}
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="app-content content">
        <div class="content-wrapper">
            <div class="content-body">

                <?php if (isset($component)) { $__componentOriginalddcd638d544798a22b5064bdbb7bdb0c = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalddcd638d544798a22b5064bdbb7bdb0c = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.dashboard.layouts.breadcrumb','data' => ['now' => ''.e(__('Submission Details')).'']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('dashboard.layouts.breadcrumb'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['now' => ''.e(__('Submission Details')).'']); ?>
                    <li class="breadcrumb-item">
                        <a href="<?php echo e(route('teacher.questions-bank.index')); ?>"><?php echo e(__('Questions bank')); ?></a>
                    </li>
                 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalddcd638d544798a22b5064bdbb7bdb0c)): ?>
<?php $attributes = $__attributesOriginalddcd638d544798a22b5064bdbb7bdb0c; ?>
<?php unset($__attributesOriginalddcd638d544798a22b5064bdbb7bdb0c); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalddcd638d544798a22b5064bdbb7bdb0c)): ?>
<?php $component = $__componentOriginalddcd638d544798a22b5064bdbb7bdb0c; ?>
<?php unset($__componentOriginalddcd638d544798a22b5064bdbb7bdb0c); ?>
<?php endif; ?>

                <section id="submission-details" class="mt-3">
                    <div class="row justify-content-center">
                        <div class="col-md-11">
                            <div class="card shadow rounded">

                                <div class="card-header bg-primary d-flex justify-content-center" style="padding-bottom:20px;">
                                    <h5 class="question-title"><?php echo e(__('Submission Details')); ?></h5>
                                </div>

                                <div class="card-body">
                                    
                                    <div class="row mb-3">
                                        <div class="col-md-4">
                                            <strong><?php echo e(__('Exam')); ?>:</strong>
                                            <p class="mb-0"><?php echo e($submission->exam->title ?? ('#'.$submission->exam_id)); ?></p>
                                        </div>
                                        <div class="col-md-4">
                                            <strong><?php echo e(__('Student')); ?>:</strong>
                                            <p class="mb-0"><?php echo e($submission->student->name ?? '-'); ?></p>
                                        </div>
                                        <div class="col-md-4">
                                            <strong><?php echo e(__('Submitted At')); ?>:</strong>
                                            <p class="mb-0"><?php echo e($submission->updated_at); ?></p>
                                        </div>
                                    </div>

                                    <hr>

                                    
                                    <div class="table-responsive">
                                        <table class="table table-bordered align-middle">
                                            <thead>
                                            <tr>
                                                <th style="width:60px">#</th>
                                                <th><?php echo e(__('Question')); ?></th>
                                                <th style="width:180px"><?php echo e(__('Correct Answer')); ?></th>
                                                <th style="width:220px"><?php echo e(__('Student Answer')); ?></th>
                                                <th style="width:90px"><?php echo e(__('Score')); ?></th>
                                                <th style="width:110px"><?php echo e(__('Result')); ?></th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            <?php $__currentLoopData = $submission->spacificStudentSubmissionQuestions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $idx => $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php
                                                    $q = $row->question;
                                                    $isMcq = $q && $q->question_type === 'mcq';

                                                    // Student's answer is option_id for MCQ
                                                    $studentOptionId   = $isMcq ? (string)($row->answer ?? '') : null;
                                                    $studentOption     = $isMcq && $q->options
                                                                            ? $q->options->first(fn($o) => (string)$o->id === $studentOptionId)
                                                                            : null;
                                                    $studentAnswerText = $isMcq
                                                                            ? ($studentOption->answer ?? null)
                                                                            : ($row->answer ?? null);

                                                    // Correct answer text
                                                    $correctText = $isMcq
                                                        ? optional($q->options->firstWhere('is_correct', 1))->answer
                                                        : ($q->answer ?? null);

                                                    // Images
                                                    $questionImg = $q->getFirstMediaUrl('image') ?? null;
                                                ?>

                                                <tr>
                                                    <td><?php echo e($idx + 1); ?></td>

                                                    
                                                    <td>
                                                        
                                                        <div class="fw-semibold mb-2"><?php echo e($q->question_text ?? '-'); ?></div>

                                                        
                                                        <?php if($questionImg): ?>
                                                            <img
                                                                src="<?php echo e($questionImg); ?>"
                                                                alt="<?php echo e(__('Question Image')); ?>"
                                                                class="q-img pointer"
                                                                onclick="openImageModal('<?php echo e($questionImg); ?>')"
                                                            >
                                                        <?php endif; ?>

                                                        
                                                        <div class="q-meta">
                                                            <div class="item">
                                                                <span class="label"><?php echo e(__('Question Type')); ?></span>
                                                                <span class="value">
                                                                    <span class="badge-chip badge-blue"><?php echo e(__($q->question_type ?? '-')); ?></span>
                                                                </span>
                                                            </div>
                                                            <div class="item">
                                                                <span class="label"><?php echo e(__('Question Score')); ?></span>
                                                                <span class="value">
                                                                    <span class="badge-chip badge-blue"><?php echo e($q->score ?? 0); ?></span>
                                                                </span>
                                                            </div>
                                                            <div class="item">
                                                                <span class="label"><?php echo e(__('Difficulty Level')); ?></span>
                                                                <?php
                                                                    $diffChip = match($q->difficulty_level ?? null) {
                                                                        'easy'   => 'badge-green',
                                                                        'medium' => 'badge-gray',
                                                                        'hard'   => 'badge-red',
                                                                        default  => 'badge-gray',
                                                                    };
                                                                ?>
                                                                <span class="value">
                                                                    <span class="badge-chip <?php echo e($diffChip); ?>"><?php echo e(__($q->difficulty_level ?? '-')); ?></span>
                                                                </span>
                                                            </div>
                                                        </div>

                                                        
                                                        <?php if($isMcq && $q->options && $q->options->count()): ?>
                                                            <div class="mb-2 fw-bold"><?php echo e(__('Choices')); ?>:</div>
                                                            <div class="choices">
                                                                <?php $__currentLoopData = $q->options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $opt): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                    <?php
                                                                        $isCorrect = (bool) $opt->is_correct;
                                                                        $isChosen  = (string)$opt->id === $studentOptionId;
                                                                        $optImg    = $opt->getFirstMediaUrl('answers_image') ?? null;
                                                                    ?>

                                                                    <div class="choice <?php echo e($isCorrect ? 'is-correct' : ''); ?> <?php echo e($isChosen ? 'is-picked' : ''); ?>">
                                                                        <div class="num"><?php echo e($loop->iteration); ?></div>
                                                                        <div class="text">
                                                                            <div><?php echo e($opt->answer); ?></div>
                                                                            <?php if($optImg): ?>
                                                                                <img
                                                                                    src="<?php echo e($optImg); ?>"
                                                                                    alt="<?php echo e(__('Option Image')); ?>"
                                                                                    class="opt-img pointer"
                                                                                    onclick="openImageModal('<?php echo e($optImg); ?>')"
                                                                                >
                                                                            <?php endif; ?>
                                                                        </div>
                                                                        <div class="marks">
                                                                            <?php if($isCorrect): ?>
                                                                                <span class="badge-chip badge-green"><?php echo e(__('Correct')); ?></span>
                                                                            <?php endif; ?>
                                                                            <?php if($isChosen): ?>
                                                                                <span class="badge-chip badge-blue"><?php echo e(__('Picked')); ?></span>
                                                                            <?php endif; ?>
                                                                        </div>
                                                                    </div>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            </div>
                                                        <?php elseif(!empty($q->answer)): ?>
                                                            
                                                            <div class="mt-2">
                                                                <span class="fw-bold"><?php echo e(__('Answer')); ?>:</span>
                                                                <span><?php echo e($q->answer); ?></span>
                                                            </div>
                                                        <?php endif; ?>
                                                    </td>

                                                    
                                                    <td><?php echo e($correctText ?? '-'); ?></td>
                                                    <td><?php echo e($studentAnswerText ?? '-'); ?></td>
                                                    <td><?php echo e($q->score ?? 0); ?></td>
                                                    <td>
                                                        <?php if((int)$row->is_correct === 1): ?>
                                                            <span class="badge-chip badge-green"><?php echo e(__('Correct')); ?></span>
                                                        <?php else: ?>
                                                            <span class="badge-chip badge-red"><?php echo e(__('Wrong')); ?></span>
                                                        <?php endif; ?>
                                                    </td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </tbody>
                                        </table>
                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>
                </section>

            </div>
        </div>
    </div>

    
    <div id="imageModal">
        <span class="closeBtn" onclick="closeImageModal()">&times;</span>
        <img id="imageModalImg" src="" alt="Preview">
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script>
        function openImageModal(src){
            const m = document.getElementById('imageModal');
            document.getElementById('imageModalImg').src = src;
            m.style.display = 'flex';
        }
        function closeImageModal(){
            document.getElementById('imageModal').style.display = 'none';
            document.getElementById('imageModalImg').src = '';
        }
        document.getElementById('imageModal')?.addEventListener('click', function(e){
            if(e.target.id === 'imageModal'){ closeImageModal(); }
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('components.dashboard.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/am2/public_html/resources/views/dashboard/quiz-exams/show_submission_questions.blade.php ENDPATH**/ ?>