<nav class="header-navbar navbar-expand-lg navbar navbar-with-menu floating-nav navbar-light navbar-shadow">
    <div class="navbar-wrapper">
        <div class="navbar-container content">
            <div class="navbar-collapse" id="navbar-mobile">
                <div class="mr-auto float-left bookmark-wrapper d-flex align-items-center">
                    <ul class="nav navbar-nav">
                        <li class="nav-item mobile-menu d-xl-none mr-auto"><a class="nav-link nav-menu-main menu-toggle hidden-xs" href="#"><i class="ficon feather icon-menu"></i></a></li>
                    </ul>
                    <ul class="nav navbar-nav bookmark-icons">
                        <li class="nav-item d-none d-lg-block"><a class="nav-link nav-link-expand"><i class="ficon feather icon-maximize"></i></a></li>
                    </ul>
                </div>
                <div class="dropdown">
                    <button class="btn btn-secondary dropdown-toggle" type="button" id="languageDropdown" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                        <?php echo e(__("language")); ?>

                    </button>
                    <div class="dropdown-menu" aria-labelledby="languageDropdown">
                        <?php $__currentLoopData = LaravelLocalization::getSupportedLocales(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $localeCode => $properties): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <a class="dropdown-item" rel="alternate" hreflang="<?php echo e($localeCode); ?>" href="<?php echo e(LaravelLocalization::getLocalizedURL($localeCode, null, [], true)); ?>">
                                <?php echo e($properties['native']); ?>

                            </a>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
                <ul class="nav navbar-nav float-right">
                    <?php if(auth()->user()): ?>
                        <li class="dropdown dropdown-notification nav-item" id="notifications-icon"><a class="nav-link nav-link-label" href="#" data-toggle="dropdown"><i class="ficon feather icon-bell"></i><span class="badge badge-pill badge-primary badge-up" ><?php echo e(auth()->user()->unreadNotifications()->count()??''); ?></span></a>
                            <ul class="dropdown-menu dropdown-menu-media dropdown-menu-right">
                                <li class="dropdown-menu-header">
                                    <div class="dropdown-header m-0 p-2">
                                        <h3 id="count" class="white"><?php echo e(auth()->user()->unreadNotifications()->count()??''); ?> <?php echo e(__('New')); ?></h3><span class="notification-title"><?php echo e(__('App Notifications')); ?></span>
                                    </div>
                                </li>
                                <li class="scrollable-container media-list">
                                    <?php $__currentLoopData = auth()->user()->notifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php
                                            $locale = app()->getLocale();
                                            $title = is_array($notification->data['title'])
                                                        ? ($notification->data['title'][$locale] ?? $notification->data['title']['en'])
                                                        : $notification->data['title'];

                                            $body = is_array($notification->data['body'])
                                                        ? ($notification->data['body'][$locale] ?? $notification->data['body']['en'])
                                                        : $notification->data['body'];
                                        ?>
                                        <a class="d-flex justify-content-between" href="javascript:void(0)">
                                            <div class="media d-flex align-items-start">
                                                <div class="media-left"><i class="feather icon-download-cloud font-medium-5 success"></i></div>
                                                <div class="media-body">
                                                    <h6 class="success media-heading red darken-1"><?php echo e($title); ?></h6>
                                                    <small class="notification-text text-bold-700"><?php echo $body; ?></small>
                                                </div>
                                                <small>
                                                    <time class="media-meta" datetime="<?php echo e($notification->created_at); ?>"><?php echo e($notification->created_at->diffForHumans()); ?></time>
                                                </small>
                                            </div>
                                        </a>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                </li>
                                <li class="dropdown-menu-footer">
                                    <form id="markAsReadForm" action="<?php echo e(route('admin.notification.markAsRead')); ?>" method="POST">
                                        <?php echo csrf_field(); ?>
                                        <button type="submit" style="width: 100%;" class="dropdown-item p-1 text-center"><?php echo e(__('Read All')); ?></button>
                                    </form>
                                </li>
                            </ul>
                        </li>
                    <?php endif; ?>
                    <li class="dropdown dropdown-user nav-item"><a class="dropdown-toggle nav-link dropdown-user-link" href="#" data-toggle="dropdown">
                            <div class="user-nav d-sm-flex d-none"><span class="user-name text-bold-600"><?php echo e(auth('web')->user()->name); ?></span><span class="user-status"><?php echo e(optional(auth()->user())->name); ?></span></div><span><img class="round" src="<?php echo e(asset('dashboardAssets/app-assets/images/logo/logo.png')); ?>" alt="avatar" height="40" width="40"></span>
                        </a>
                        <div style="width: 200px;" class="dropdown-menu dropdown-menu-right">
                            <?php if(auth()->check()): ?>
                                <a class="dropdown-item" href="<?php echo e(route('admin.profile.edit')); ?>"><i class="feather icon-user"></i> <?php echo e(__('Edit Profile')); ?></a>
                                <div class="dropdown-divider"></div>
                            <?php endif; ?>
                            <a class="dropdown-item" href="<?php echo e(route('admin.logout')); ?>"><i class="feather icon-power"></i> <?php echo e(__('Logout')); ?></a>
                        </div>
                    </li>
                </ul>
            </div>
        </div>
    </div>
</nav>
<?php /**PATH /home/am2/public_html/resources/views/components/dashboard/layouts/navbar.blade.php ENDPATH**/ ?>