<?php $__env->startSection('styles'); ?>
    <?php echo $__env->yieldPushContent('datatableStyles'); ?>
    <style>
        /* ===== Installment Form Styles ===== */
        .installment-form .form-label{font-weight:600;}
        .installment-form .form-control,
        .installment-form .form-select{height:44px;}
        .installment-form .form-control[readonly],
        .installment-form .form-control:disabled{
            background:#f5f7fb; cursor:not-allowed; color:#6e6b7b;
        }
        .installment-form .mb-1{margin-bottom:1rem !important;}
        .installment-form .hint{font-size:.86rem; color:#8a8d93;}
        .installment-form .card-header{border-bottom:1px solid #ebe9f1;}
        .installment-form .btn{min-width:140px}
        .installment-form .form-check-input{
            width:3rem; height:1.5rem;
        }
        .installment-form .form-check-input:checked{
            background-color:#7367F0; border-color:#7367F0;
        }
        @media (max-width:576px){
            .installment-form .btn{width:100%}
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('title'); ?>
    <?php echo e(__('Add installment')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="app-content content">
        <div class="content-overlay"></div>
        <div class="header-navbar-shadow"></div>
        <div class="content-wrapper">
            <div class="content-header row"></div>
            <div class="content-body">

                <section class="users-list-wrapper">
                    <?php if (isset($component)) { $__componentOriginalddcd638d544798a22b5064bdbb7bdb0c = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalddcd638d544798a22b5064bdbb7bdb0c = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.dashboard.layouts.breadcrumb','data' => ['now' => ''.e(__('Add installment')).'']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('dashboard.layouts.breadcrumb'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['now' => ''.e(__('Add installment')).'']); ?> <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalddcd638d544798a22b5064bdbb7bdb0c)): ?>
<?php $attributes = $__attributesOriginalddcd638d544798a22b5064bdbb7bdb0c; ?>
<?php unset($__attributesOriginalddcd638d544798a22b5064bdbb7bdb0c); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalddcd638d544798a22b5064bdbb7bdb0c)): ?>
<?php $component = $__componentOriginalddcd638d544798a22b5064bdbb7bdb0c; ?>
<?php unset($__componentOriginalddcd638d544798a22b5064bdbb7bdb0c); ?>
<?php endif; ?>

                    <section id="installment-create" class="installment-form">
                        <div class="row">
                            <div class="col-12">
                                <div class="card">
                                    <div class="card-header d-flex justify-content-between align-items-center">
                                        <h4 class="card-title mb-0"><?php echo e(__('Add installment')); ?></h4>
                                    </div>

                                    <div class="card-content">
                                        <div class="card-body">
                                            <form method="POST" action="<?php echo e(route('teacher.installments.store')); ?>">
                                                <?php echo csrf_field(); ?>

                                                
                                                <input type="hidden" name="course_id" value="<?php echo e($courseId); ?>">

                                                <div class="row">
                                                    
                                                    <div class="col-md-6 mb-1">
                                                        <label class="form-label"><?php echo e(__('Amount')); ?> <span class="text-danger">*</span></label>
                                                        <input type="number" step="0.01" min="0" name="amount"
                                                               value="<?php echo e(old('amount')); ?>"
                                                               class="form-control <?php $__errorArgs = ['amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" required>
                                                        <?php $__errorArgs = ['amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><div class="invalid-feedback"><?php echo e($message); ?></div><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                    </div>

                                                    
                                                    <div class="col-md-6 mb-1" id="min-amount">
                                                        <label class="form-label"><?php echo e(__('Minimum amount')); ?></label>
                                                        <input type="number" step="0.01" min="0" name="minimum_amount"
                                                               value="<?php echo e(old('minimum_amount')); ?>"
                                                               class="form-control <?php $__errorArgs = ['minimum_amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                                                        <small class="hint"><?php echo e(__('Optional: minimum amount accepted for this installment')); ?></small>
                                                        <?php $__errorArgs = ['minimum_amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><div class="invalid-feedback"><?php echo e($message); ?></div><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                    </div>

                                                    
                                                    <div class="col-md-6 mb-1">
                                                        <label class="form-label"><?php echo e(__('Due date')); ?> <span class="text-danger">*</span></label>
                                                        <input type="date" name="due_date" value="<?php echo e(old('due_date')); ?>"
                                                               class="form-control <?php $__errorArgs = ['due_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" required>
                                                        <?php $__errorArgs = ['due_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><div class="invalid-feedback"><?php echo e($message); ?></div><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                    </div>

                                                    
                                                    <div class="col-md-6 mb-1">
                                                        <label class="form-label"><?php echo e(__('Installment number')); ?></label>
                                                        <select class="form-select form-control installment-number"
                                                                name="installment_number" required>
                                                            <?php $__currentLoopData = $installmentsNumbers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $number): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <option value="<?php echo e(++$index); ?>" <?php if(old('installment_number', $defaultInstallmentNumber ?? null) == $number): echo 'selected'; endif; ?>>
                                                                    <?php echo e($number); ?>

                                                                </option>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </select>
                                                        <?php $__errorArgs = ['installment_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><div class="invalid-feedback"><?php echo e($message); ?></div><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                    </div>

                                                    
                                                    <div class="col-12 col-md-6 col-lg-4 mb-1"> 
                                                        <label class="form-label d-block"><?php echo e(__('Is final installment?')); ?></label>

                                                        
                                                        <input type="hidden" name="is_final" value="0">

                                                        <div class="form-check form-switch">
                                                            <input
                                                                class="form-check-input <?php $__errorArgs = ['is_final'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                                type="checkbox"
                                                                id="is_final"
                                                                name="is_final"
                                                                value="1"
                                                                <?php if(old('is_final', $defaultIsFinal ?? false)): echo 'checked'; endif; ?>
                                                                role="switch"
                                                                aria-describedby="is_final_help"
                                                            >

                                                            <?php $__errorArgs = ['is_final'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><div class="invalid-feedback d-block"><?php echo e($message); ?></div><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                        </div>

                                                    </div>

                                                </div>

                                                <div class="mt-2 d-flex gap-1 flex-wrap">
                                                    <button type="submit" class="btn btn-primary">
                                                        <?php echo e(__('Save')); ?>

                                                    </button>
                                                </div>
                                            </form>
                                        </div> 
                                    </div>
                                </div>
                            </div>
                        </div>
                    </section>
                </section>

            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <?php echo $__env->yieldPushContent('datatableScripts'); ?>
    <script>
        // check if select has only 1 and it's 3
        // when loaded
        document.addEventListener('DOMContentLoaded', function() {
            let installmentSelect = document.querySelector('.installment-number');
            if (installmentSelect && installmentSelect.options.length === 1 && installmentSelect.value == 3) {
                document.getElementById('is_final').checked = true;
                document.getElementById('is_final').disabled = true; // disable the checkbox
                // hidden minimum amount field
                document.getElementById('min-amount').style.display = 'none';
            }
        });
        document.querySelector('.installment-number').addEventListener('change', function() {
            let selectedValue = this.value;
            if (selectedValue == 3) {
                document.getElementById('is_final').checked = true;
                document.getElementById('is_final').disabled = true;
                // hidden minimum amount field
                document.getElementById('min-amount').style.display = 'none';
            }else{
                document.getElementById('is_final').checked = false;
                document.getElementById('is_final').disabled = false; // enable the checkbox
                // show minimum amount field
                document.getElementById('min-amount').style.display = 'block';
            }
        });
        // check if is_final checked display none min-amount else show it
        document.getElementById('is_final').addEventListener('change', function() {
            if (this.checked) {
                document.getElementById('min-amount').style.display = 'none';
                // clear value of input
                document.querySelector('input[name="minimum_amount"]').value = '';
            } else {
                document.getElementById('min-amount').style.display = 'block';
            }
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('components.dashboard.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/am2/public_html/resources/views/dashboard/installments/create.blade.php ENDPATH**/ ?>