<?php $__env->startSection('styles'); ?>
    <?php echo $__env->yieldPushContent('datatableStyles'); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('title'); ?>
    <?php echo e(__('Student Exam Levels')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('styles'); ?>
    <!-- Tailwind CSS CDN -->
    <script src="https://cdn.tailwindcss.com"></script>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="app-content content">
        <div class="content-overlay"></div>
        <div class="header-navbar-shadow"></div>
        <div class="content-wrapper">
            <div class="content-header row"></div>
            <div class="content-body">
                <section class="users-list-wrapper">
                    <?php if (isset($component)) { $__componentOriginalddcd638d544798a22b5064bdbb7bdb0c = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalddcd638d544798a22b5064bdbb7bdb0c = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.dashboard.layouts.breadcrumb','data' => ['now' => ''.e(__('Student Exam Levels')).'']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('dashboard.layouts.breadcrumb'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['now' => ''.e(__('Student Exam Levels')).'']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalddcd638d544798a22b5064bdbb7bdb0c)): ?>
<?php $attributes = $__attributesOriginalddcd638d544798a22b5064bdbb7bdb0c; ?>
<?php unset($__attributesOriginalddcd638d544798a22b5064bdbb7bdb0c); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalddcd638d544798a22b5064bdbb7bdb0c)): ?>
<?php $component = $__componentOriginalddcd638d544798a22b5064bdbb7bdb0c; ?>
<?php unset($__componentOriginalddcd638d544798a22b5064bdbb7bdb0c); ?>
<?php endif; ?>

                    <section id="student-exam-levels">
                        <div class="row">
                            <div class="col-12">
                                <div class="card shadow-lg">
                                    <div class="card-header bg-gray-800 text-white rounded-t-lg">
                                        <h4 class="card-title"><?php echo e(__('Edit Student Exam Levels')); ?></h4>
                                    </div>
                                    <div class="card-content">
                                        <div class="card-body card-dashboard p-6">

                                            
                                            <?php if($errors->any()): ?>
                                                <div id="form-error-message" class="alert alert-danger mb-4 rounded bg-red-100 text-red-700 px-4 py-3">
                                                    <ul class="mb-0 list-disc pl-5">
                                                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <li><?php echo e($error); ?></li>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </ul>
                                                </div>
                                            <?php endif; ?>

                                            <form method="POST" action="<?php echo e(route('teacher.studentExamLevels.updateAll')); ?>">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('PUT'); ?>

                                                <div class="overflow-x-auto rounded-lg shadow border border-gray-300">
                                                    <table class="table-auto w-full text-sm text-center border-collapse">
                                                        <thead style="background-color: #0A4199;" class="text-white">
                                                        <tr>
                                                            <th class="px-4 py-2"><?php echo e(__('Level')); ?></th>
                                                            <th class="px-4 py-2"><?php echo e(__('From %')); ?></th>
                                                            <th class="px-4 py-2"><?php echo e(__('To %')); ?></th>
                                                            <th class="px-4 py-2"><?php echo e(__('Question Number')); ?></th>
                                                            <th class="px-4 py-2"><?php echo e(__('Easy %')); ?></th>
                                                            <th class="px-4 py-2"><?php echo e(__('Medium %')); ?></th>
                                                            <th class="px-4 py-2"><?php echo e(__('Hard %')); ?></th>
                                                        </tr>
                                                        </thead>
                                                        <tbody>
                                                        <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $level): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <?php $key = $level->id ?? $index; ?>
                                                            <tr class="odd:bg-white even:bg-gray-50 border-b">
                                                                <td class="px-3 py-2 font-medium text-gray-700">
                                                                    <?php echo e(__(ucfirst($level->name))); ?>

                                                                    <input type="hidden" name="levels[<?php echo e($key); ?>][id]" value="<?php echo e($level->id); ?>">
                                                                    <input type="hidden" name="levels[<?php echo e($key); ?>][name]" value="<?php echo e($level->name); ?>">
                                                                </td>
                                                                <td class="px-3 py-2">
                                                                    <input type="number" class="w-full rounded border border-gray-300 px-2 py-1"
                                                                           name="levels[<?php echo e($key); ?>][from_percent]"
                                                                           value="<?php echo e(old("levels.$key.from_percent", $level->from_percent)); ?>"
                                                                           min="0" max="100" required>
                                                                </td>
                                                                <td class="px-3 py-2">
                                                                    <input type="number" class="w-full rounded border border-gray-300 px-2 py-1"
                                                                           name="levels[<?php echo e($key); ?>][to_percent]"
                                                                           value="<?php echo e(old("levels.$key.to_percent", $level->to_percent)); ?>"
                                                                           min="0" max="100" required>
                                                                </td>
                                                                <td class="px-3 py-2">
                                                                    <input type="number" class="w-full rounded border border-gray-300 px-2 py-1"
                                                                           name="levels[<?php echo e($key); ?>][question_number]"
                                                                           value="<?php echo e(old("levels.$key.question_number", $level->question_number)); ?>"
                                                                           min="1" required>
                                                                </td>
                                                                <td class="px-3 py-2">
                                                                    <input type="number" class="w-full rounded border border-gray-300 px-2 py-1"
                                                                           name="levels[<?php echo e($key); ?>][easy_percent]"
                                                                           value="<?php echo e(old("levels.$key.easy_percent", $level->easy_percent)); ?>"
                                                                           min="0" max="100" required>
                                                                </td>
                                                                <td class="px-3 py-2">
                                                                    <input type="number" class="w-full rounded border border-gray-300 px-2 py-1"
                                                                           name="levels[<?php echo e($key); ?>][medium_percent]"
                                                                           value="<?php echo e(old("levels.$key.medium_percent", $level->medium_percent)); ?>"
                                                                           min="0" max="100" required>
                                                                </td>
                                                                <td class="px-3 py-2">
                                                                    <input type="number" class="w-full rounded border border-gray-300 px-2 py-1"
                                                                           name="levels[<?php echo e($key); ?>][hard_percent]"
                                                                           value="<?php echo e(old("levels.$key.hard_percent", $level->hard_percent)); ?>"
                                                                           min="0" max="100" required>
                                                                </td>
                                                            </tr>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </tbody>
                                                    </table>
                                                </div>

                                                
                                                <div id="js-error-message" class="alert alert-danger d-none mt-4 text-red-600 text-sm"></div>

                                                <div class="text-center mt-6">
                                                    <button type="submit" class="bg-green-600 hover:bg-green-700 text-white font-bold py-2 px-6 rounded shadow">
                                                        <i class="fa fa-save mr-1"></i> <?php echo e(__('Save All')); ?>

                                                    </button>
                                                </div>
                                            </form>

                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </section>
                </section>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <?php echo $__env->yieldPushContent('datatableScripts'); ?>
    <!-- Tailwind CSS CDN -->
    <script src="https://cdn.tailwindcss.com"></script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('components.dashboard.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/am2/public_html/resources/views/dashboard/student-exam-levels/index.blade.php ENDPATH**/ ?>