<a href="#" class="btn btn-sm btn-outline-primary"
   data-toggle="modal"
   data-target="#showPaymentsModal"
   data-student-id="<?php echo e($studentId); ?>"
   data-course-id="<?php echo e($courseId); ?>"
   data-course-name="<?php echo e($CourseName ?? ''); ?>"
   data-student-name="<?php echo e($studentName ?? ''); ?>">
    <i class="fa fa-money-bill" style="font-size: 14px"></i>
</a>

<div class="modal fade" id="showPaymentsModal" tabindex="-1" role="dialog" aria-labelledby="showPaymentsLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content border-primary">
            <div class="modal-header bg-primary text-white">
                <h5 class="modal-title" id="showPaymentsLabel"><?php echo e(__('Payment Details')); ?></h5>
                <button type="button" class="close text-white" data-dismiss="modal" aria-label="<?php echo e(__('Close')); ?>">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>

            <div class="modal-body">
                <div class="text-right mb-3">
                    <button id="printPaymentsBtn" class="btn btn-sm btn-primary">
                        <i class="fa fa-print"></i> <?php echo e(__('Print')); ?>

                    </button>
                </div>
                <div id="printableArea">
                    <div class="print-header d-none">
                        <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 15px;">
                            <div>
                                <img src="<?php echo e(asset('/dashboardAssets/app-assets/images/logo/logo.png')); ?>" style="height: 60px;">
                            </div>
                            <div style="text-align: right;">
                                <h4 style="margin: 0; color: #333;"><?php echo e(__('Payment Details')); ?></h4>
                                <p style="margin: 5px 0 0; color: #666; font-size: 13px;">
                                    <?php echo e(__('Course Name')); ?>: <span id="printCourseName"></span>
                                    <br>
                                    <?php echo e(__('Student Name')); ?>: <span id="printStudentName"></span>
                                </p>
                                <p style="margin: 5px 0 0; color: #666; font-size: 13px;">
                                    <?php echo e(__('Print Date')); ?>: <span id="printDate"></span>
                                </p>
                            </div>
                        </div>
                        <hr style="border-top: 1px solid #ddd; margin: 10px 0;">
                    </div>
                    <table class="table table-bordered table-hover">
                        <thead class="thead-light">
                        <tr>
                            <th style="width: 10%;"><?php echo e(__('Installment')); ?></th>
                            <th style="width: 15%;"><?php echo e(__('Amount')); ?></th>

                            <th style="width: 15%;"><?php echo e(__('Date')); ?></th>
                            <th style="width: 45%;"><?php echo e(__('Notes')); ?></th>
                        </tr>
                        </thead>
                        <tbody id="paymentDetailsBody">
                        <tr><td colspan="5" class="text-center text-muted"><?php echo e(__('Loading...')); ?></td></tr>
                        </tbody>
                    </table>
                    <div class="print-footer d-none">
                        <hr style="border-top: 1px solid #ddd; margin: 15px 0 10px;">
                        <p style="text-align: right; font-size: 12px; color: #666; margin: 0;">
                            <?php echo e(__('Printed by')); ?>: <?php echo e(Auth::user()->name ?? 'System'); ?> | <?php echo e(__('Page')); ?> <span class="pageNumber"></span>
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    @media print {
        body * {
            visibility: hidden;
        }
        #printableArea, #printableArea * {
            visibility: visible;
        }
        #printableArea {
            position: absolute;
            left: 0;
            top: 0;
            width: 100%;
            padding: 20px;
        }
        .print-header, .print-footer {
            display: block !important;
        }
        .table {
            width: 100%;
            border-collapse: collapse;
            font-size: 12px;
        }
        .table th, .table td {
            padding: 8px;
            border: 1px solid #ddd;
            word-wrap: break-word;
        }
        .table th {
            background-color: #f8f9fa !important;
            color: #000 !important;
        }
        .badge {
            color: #fff !important;
            padding: 4px 8px;
            border-radius: 4px;
            font-size: 12px;
        }
        .badge-danger {
            background-color: #dc3545 !important;
        }
        .badge-success {
            background-color: #28a745 !important;
        }
        .badge-warning {
            background-color: #ffc107 !important;
        }
        .notes-cell {
            max-width: 200px;
            word-wrap: break-word;
            white-space: normal !important;
        }
        @page {
            size: A4 portrait;
            margin: 15mm;
        }
        .d-none {
            display: none;
        }
    }
</style>

<script>
    $(document).ready(function () {
        $(document).on('click','.loadFullText', function () {
            const fullText = $(this).data('text');
            const $this = $(this);
            if ($this.text() === fullText) {
                $this.text(fullText.substring(0, 20) + '...');
            } else {
                $this.text(fullText);
            }
        });

        // Print button functionality
        $('#printPaymentsBtn').click(function() {
            // Set print header information
            const button = $('[data-target="#showPaymentsModal"]');
            $('#printCourseName').text(button.data('course-name') || '<?php echo e(__('Unknown Course')); ?>');
            $('#printStudentName').text(button.data('student-name') || '<?php echo e(__('Unknown Student')); ?>');
            $('#printDate').text(new Date().toLocaleString());

            const printContents = $('#printableArea').clone();

            // Show all notes in full when printing and apply special formatting
            printContents.find('.loadFullText').each(function() {
                const fullText = $(this).data('text');
                $(this).text(fullText).addClass('notes-cell').css({
                    'white-space': 'normal',
                    'word-wrap': 'break-word'
                });
            });

            // Create a new window for printing
            const printWindow = window.open('', '', 'width=800,height=600');
            printWindow.document.write(`
                <!DOCTYPE html>
                <html>
                <head>
                    <title><?php echo e(__('Payment Details')); ?></title>
                    <style>
                        body {
                            font-family: Arial, sans-serif;
                            margin: 0;
                            padding: 20px;
                            color: #333;
                        }
                        .print-header {
                            margin-bottom: 15px;
                        }
                        .print-footer {
                            margin-top: 15px;
                            font-size: 12px;
                        }
                        h4 {
                            margin: 0 0 5px 0;
                            color: #333;
                        }
                        .table {
                            width: 100%;
                            border-collapse: collapse;
                            margin-bottom: 15px;
                            font-size: 12px;
                        }
                        .table th, .table td {
                            padding: 8px;
                            border: 1px solid #ddd;
                            word-wrap: break-word;
                        }
                        .table th {
                            background-color: #f8f9fa;
                            color: #000;
                        }
                        .badge {
                            color: #fff;
                            padding: 4px 8px;
                            border-radius: 4px;
                            display: inline-block;
                            font-size: 12px;
                        }
                        .badge-danger {
                            background-color: #dc3545;
                        }
                        .badge-success {
                            background-color: #28a745;
                        }
                        .badge-warning {
                            background-color: #ffc107;
                        }
                        hr {
                            border-top: 1px solid #ddd;
                            margin: 10px 0;
                        }
                        .text-right {
                            text-align: right;
                        }
                        .text-muted {
                            color: #6c757d;
                        }
                        .notes-cell {
                            max-width: 200px;
                            word-wrap: break-word;
                            white-space: normal;
                        }
                        @page {
                            size: A4 portrait;
                            margin: 15mm;
                        }
                    </style>
                </head>
                <body>
                    ${printContents.html()}
                    <script>
                        // Add page numbers
                        document.addEventListener('DOMContentLoaded', function() {
                            const totalPages = Math.ceil(document.body.scrollHeight / 1122); // A4 height in pixels at 96dpi
                            const pageNumbers = document.querySelectorAll('.pageNumber');
                            pageNumbers.forEach(el => {
                                el.textContent = '1/' + totalPages;
                            });

                            // Auto-print and close
                            setTimeout(function() {
                                window.print();
                                setTimeout(function() {
                                    window.close();
                                }, 300);
                            }, 500);
                        });
                    <\/script>
                </body>
                </html>
            `);
            printWindow.document.close();
        });
    });

    $('#showPaymentsModal').on('show.bs.modal', function (event) {
        const button = $(event.relatedTarget);
        const studentId = button.data('student-id');
        const courseId = button.data('course-id');
        const studentName = button.data('student-name') || '<?php echo e(__('Unknown Student')); ?>';
        const courseName = button.data('course-name') || '<?php echo e(__('Unknown Course')); ?>';
        const $tbody = $('#paymentDetailsBody');

        // Update print header info
        $('#printCourseName').text(courseName);
        $('#printStudentName').text(studentName);

        $tbody.html(`<tr><td colspan="5" class="text-center text-muted"><?php echo e(__('Loading...')); ?></td></tr>`);
        $.ajax({
            url: "<?php echo e(route('teacher.students.getPayments')); ?>",
            type: 'GET',
            data: {
                student_id: studentId,
                course_id: courseId
            },
            success: function (data) {
                if (!data || data.length === 0) {
                    $tbody.html(`<tr><td colspan="5" class="text-center text-muted"><?php echo e(__('No Payments Found')); ?></td></tr>`);
                } else {
                    let rows = '';
                    data.forEach(payment => {



                        let noteText = payment.notes && payment.notes.length > 20
                            ? payment.notes.substring(0, 20) + "..."
                            : (payment.notes || '--');

                        if (payment.installment) {
                            switch (payment.installment.installment_number) {
                                case 1:
                                    installmentName = '<?php echo e(__("First Installment")); ?>';
                                    break;
                                case 2:
                                    installmentName = '<?php echo e(__("Second Installment")); ?>';
                                    break;
                                case 3:
                                    installmentName = '<?php echo e(__("Final Installment")); ?>';
                                    break;
                                default:
                                    installmentName = '--';
                            }
                        }


                        rows += `
                            <tr>
                                <td>${installmentName}</td>
                                <td>${payment.amount || '0.00'}</td>

                                <td>${payment.date || '--'}</td>
                                <td data-text="${payment.notes ? payment.notes.replace(/"/g, '&quot;') : ''}"
                                    class="loadFullText"
                                    style="${payment.notes && payment.notes.length > 20 ? 'cursor:pointer;' : ''}">
                                    ${noteText}
                                </td>
                            </tr>
                        `;
                    });
                    $tbody.html(rows);
                }
            },
            error: function () {
                $tbody.html(`<tr><td colspan="5" class="text-center text-danger"><?php echo e(__('Error loading payments')); ?></td></tr>`);
            }
        });
    });
</script>
<?php /**PATH /home/am2/public_html/resources/views/components/datatable/includes/columns/show-payments.blade.php ENDPATH**/ ?>