<?php $__env->startSection('title', __('dashboard.dashboard')); ?>

<?php $__env->startSection('styles'); ?>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <style>
        body {
            font-family: 'Cairo', sans-serif;
            background-color: #f8f9fc;
            color: #2c3e50;
        }

        .dashboard {
            padding: 2rem;
            max-width: 1200px;
            margin: auto;
        }

        .heading {
            text-align: center;
            font-size: 2rem;
            font-weight: 700;
            margin-bottom: 2.5rem;
        }

        .metrics-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 1.5rem;
            margin-bottom: 3rem;
        }

        .metric-card {
            background: #fff;
            border-radius: 1rem;
            padding: 1.5rem;
            box-shadow: 0 8px 24px rgba(0, 0, 0, 0.05);
            text-align: center;
            transition: transform 0.2s ease;
        }

        .metric-card:hover {
            transform: translateY(-5px);
        }

        .metric-title {
            font-size: 1rem;
            font-weight: 600;
            margin-bottom: 0.5rem;
            color: #7f8c8d;
        }

        .metric-value {
            font-size: 2.2rem;
            font-weight: 700;
        }

        .charts-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(320px, 1fr));
            gap: 2rem;
        }

        .chart-card {
            background: #fff;
            border-radius: 1rem;
            padding: 1.5rem;
            box-shadow: 0 8px 24px rgba(0, 0, 0, 0.05);
        }

        .chart-title {
            font-size: 1.1rem;
            font-weight: 600;
            margin-bottom: 1rem;
        }

        .chart-container {
            position: relative;
            height: 260px;
        }

    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <?php $isTeacher = auth()->user()->type === 'teacher'; ?>

    <div class="dashboard">
        <div class="heading">
            📊 <?php echo e(__('Dashboard Overview')); ?>

        </div>

        <!-- METRIC CARDS -->
        <div class="metrics-grid">
            <div class="metric-card">
                <div class="metric-title">📚 <?php echo e(__('Total Courses')); ?></div>
                <div class="metric-value" id="totalCourses" style="color: #ff9f40;"><?php echo e($allcourses); ?></div>
            </div>
            <div class="metric-card">
                <div class="metric-title">🎓 <?php echo e(__('Total Enrolled Students')); ?></div>
                <div class="metric-value" id="totalStudents" style="color: #4bc0c0;"><?php echo e($allstudents); ?></div>
            </div>
            <?php if (! ($isTeacher)): ?>
                <div class="metric-card">
                    <div class="metric-title">🧑‍🏫 <?php echo e(__('Total Teachers')); ?></div>
                    <div class="metric-value" id="totalTeachers" style="color: #9966ff;"><?php echo e($allteachers); ?></div>
                </div>
            <?php endif; ?>
        </div>

        <!-- CHARTS -->
        <div class="charts-grid">
            <div class="chart-card">
                <div class="chart-title"><?php echo e(__('Monthly Courses')); ?></div>
                <div class="chart-container">
                    <canvas id="monthlyCoursesChart"></canvas>
                </div>
            </div>

            <div class="chart-card">
                <div class="chart-title"><?php echo e(__('Monthly Students')); ?></div>
                <div class="chart-container">
                    <canvas id="monthlyStudentsChart"></canvas>
                </div>
            </div>

            <?php if (! ($isTeacher)): ?>
                <div class="chart-card">
                    <div class="chart-title"><?php echo e(__('Monthly Teachers')); ?></div>
                    <div class="chart-container">
                        <canvas id="monthlyTeachersChart"></canvas>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <script>
        function animateCounter(id, value, duration) {
            const el = document.getElementById(id);
            let start = 0;
            const increment = value / (duration / 16);
            const update = () => {
                start += increment;
                el.textContent = start < value ? Math.ceil(start) : value;
                if (start < value) requestAnimationFrame(update);
            };
            requestAnimationFrame(update);
        }

        function renderLineChart(id, label, data, color) {
            const ctx = document.getElementById(id).getContext('2d');
            new Chart(ctx, {
                type: 'line',
                data: {
                    labels: <?php echo json_encode($months, 15, 512) ?>,
                    datasets: [{
                        label: label,
                        data: data,
                        borderColor: color.replace('0.2', '1'),
                        backgroundColor: color,
                        fill: false,
                        tension: 0.4,
                        pointRadius: 5,
                        pointHoverRadius: 6
                    }]
                },
                options: {
                    responsive: true,
                    plugins: {
                        legend: { position: 'top' },
                        tooltip: { mode: 'index', intersect: false }
                    },
                    interaction: { mode: 'nearest', intersect: false },
                    scales: {
                        x: {
                            title: {
                                display: true,
                                text: '<?php echo e(__("Month")); ?>',
                                font: { weight: 'bold' }
                            }
                        },
                        y: {
                            beginAtZero: true,
                            title: {
                                display: true,
                                text: label,
                                font: { weight: 'bold' }
                            }
                        }
                    }
                }
            });
        }

        document.addEventListener('DOMContentLoaded', () => {
            animateCounter('totalCourses', parseInt("<?php echo e($allcourses ?? 0); ?>"), 2000);
            animateCounter('totalStudents', parseInt("<?php echo e($allstudents ?? 0); ?>"), 2000);
            <?php if (! ($isTeacher)): ?>
            animateCounter('totalTeachers', parseInt("<?php echo e($allteachers ?? 0); ?>"), 2000);
            <?php endif; ?>

            renderLineChart('monthlyCoursesChart', '<?php echo e(__("Courses")); ?>', <?php echo json_encode($coursesCounts, 15, 512) ?>, 'rgba(255, 159, 64, 0.2)');
            renderLineChart('monthlyStudentsChart', '<?php echo e(__("Students")); ?>', <?php echo json_encode($studentsCounts, 15, 512) ?>, 'rgba(75, 192, 192, 0.2)');
            <?php if (! ($isTeacher)): ?>
            renderLineChart('monthlyTeachersChart', '<?php echo e(__("Teachers")); ?>', <?php echo json_encode($teachersCounts, 15, 512) ?>, 'rgba(153, 102, 255, 0.2)');
            <?php endif; ?>
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('components.dashboard.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/am2/public_html/resources/views/dashboard/index.blade.php ENDPATH**/ ?>